<?xml version="1.0" encoding="UTF-8"?>
<!-- 
	Transformata generująca warstwę prezentacyjną informacji o receptach w pakiecie na potrzeby powiadomień i wydruków, 
	przygotowana przez Centrum Systemów Informacyjnych Ochrony Zdrowia.
	
	Transformata nie jest zgodna ze standardem HL7 CDA, wykorzystuje elementy HL7 CDA do wyświetlenia wybranych informacji z dokumentów medycznych.
	
	Wersja pl_informacja_o_receptach_1.3.1:1.0 dla CDA_PL_IG_1.3.1.
	
	Historia wersji:
		- pl_informacja_o_receptach_1.0:1.0, 1904 linie kodu, autor Marcin Pusz, Pentacomp Systemy Informatyczne S.A., wersja inicjalna
		- pl_informacja_o_receptach_1.3.1:1.0, 3057 linii kodu, autor Marcin Pusz, Pentacomp Systemy Informatyczne S.A., dostosowanie do IHE PRE, kod kreskowy SVG (IE9+) jako domyślna alternatywa dla zakodowanych elementów graficznych (IE8-), usunięcie zastosowania tablic globalnych ze względu na trudności z dostępem w różnych środowiskach, przebudowa układu graficznego wg projektu CSIOZ
		- pl_informacja_o_receptach_1.3.2:1.0 20220209, 3304 linii kodu, autor NT6, rozbudowa transformaty dokumentu informacyjnego recepty o informację dot. 365		
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:hl7="urn:hl7-org:v3" xmlns:extPL="http://www.csioz.gov.pl/xsd/extPL/r2" version="1.0">

	<xsl:output method="html" version="4.01" encoding="UTF-8" indent="yes" doctype-public="-//W3C//DTD HTML 4.01//EN" media-type="text/html" doctype-system="about:legacy-compat"/>
	
	<xsl:variable name="LOWERCASE_LETTERS">aąbcćdeęfghijklłmnńoópqrsśtuvwxyzżź</xsl:variable>
	<xsl:variable name="UPPERCASE_LETTERS">AĄBCĆDEĘFGHIJKLŁMNŃOÓPQRSŚTUVWXYZŻŹ</xsl:variable>
	
	<!-- 44-cyfrowy klucz pakietu recept wystarczający do realizacji recept -->
	<xsl:param name="kluczPakietu"/>
	<!-- klucz pakietu to jedyny klucz w tej wersji transformaty -->
	<xsl:variable name="klucz" select="$kluczPakietu"/>
	
	<!-- 4-cyfrowy kod dostępowy do pakietu recept, wymagający podania id usługobiorcy przy realizacji recept -->
	<xsl:param name="kodPakietu"/>
	<!-- kod pakietu to jedyny kod dostępu w tej wersji transformaty -->
	<xsl:variable name="kod" select="$kodPakietu"/>
	
	<!-- parametr opcjonalny, ustawiając dowolną wartość inną niż domyślna (np. disabled) można wyłączyć generowanie kodów kreskowych SVG i wykorzystać obsługiwane przez IE8- img -->
	<xsl:param name="SVG">enabled</xsl:param>
	
	<!-- stała dot. wysokości kodu kreskowego w pikselach (w XSLT variable to stała), aktualnie nie ma potrzeby wystawiania tego jako parametr -->
	<xsl:variable name="barcodeHeight" select="30"/>
	
	<!-- ilość recept w pakiecie, jeśli nie podano, przyjmuje się ilość wynikającą z wypełnionych parametrów
		 parametr wraz z parametrami doc*Nr umożliwia wyświetlenie podzbioru dużego pakietu recept na jednej informacji
		 np. Recepta 4 z 11 ogółem, Recepta 5 z 11 ogółem, Recepta 6 z 11 ogółem -->
	<xsl:param name="receptWPakiecie"/>
	
	<!-- dane pierwszego dokumentu recepty do wyświetlenia, dokument źródłowy przyjęto jako pierwszy -->
	<xsl:variable name="doc1" select="/"/>
	<xsl:param name="doc1Nr" select="1"/>
	
	<!-- dane drugiego dokumentu recepty do wyświetlenia -->
	<!-- opcjonalna nazwa pliku z dokumentem przydatna przy uruchamianiu transformaty z linii poleceń lub skryptów -->
	<xsl:param name="doc2FN"/>
	<!-- alternatywnie dla nazwy pliku z dokumentem możliwe jest podanie zawartości dokumentu, przydatne przy uruchamianiu transformaty w kodzie systemu -->
	<xsl:param name="doc2" select="document($doc2FN)"/>
	<xsl:param name="doc2Nr" select="2"/>
	
	<!-- dane trzeciego dokumentu recepty do wyświetlenia -->
	<xsl:param name="doc3FN"/>
	<xsl:param name="doc3" select="document($doc3FN)"/>
	<xsl:param name="doc3Nr" select="3"/>
	
	<!-- dane czwartego dokumentu recepty do wyświetlenia -->
	<xsl:param name="doc4FN"/>
	<xsl:param name="doc4" select="document($doc4FN)"/>
	<xsl:param name="doc4Nr" select="4"/>
	
	<!-- dane piątego dokumentu recepty do wyświetlenia -->
	<xsl:param name="doc5FN"/>
	<xsl:param name="doc5" select="document($doc5FN)"/>
	<xsl:param name="doc5Nr" select="5"/>
	
	<!-- ilość recept w pakiecie wyliczana, jeśli nie podano z parametru -->
	<xsl:variable name="iloscRecept">
		<xsl:call-template name="iloscRecept"/>
	</xsl:variable>
	
	<!-- opcjonalny tekst dotyczący terminu kontroli -->
	<xsl:param name="termin"/>
	
	<xsl:template match="/">
		<xsl:apply-templates select="hl7:ClinicalDocument"/>
	</xsl:template>
	
	<!-- Wyznaczenie ilości recept w pakiecie -->
	<xsl:template name="iloscRecept">
		<xsl:choose>
			<xsl:when test="$receptWPakiecie">
				<xsl:value-of select="$receptWPakiecie"/>
			</xsl:when>
			<xsl:when test="not($doc2/hl7:ClinicalDocument)">
				<xsl:value-of select="1"/>
			</xsl:when>
			<xsl:when test="not($doc3/hl7:ClinicalDocument)">
				<xsl:value-of select="2"/>
			</xsl:when>
			<xsl:when test="not($doc4/hl7:ClinicalDocument)">
				<xsl:value-of select="3"/>
			</xsl:when>
			<xsl:when test="not($doc5/hl7:ClinicalDocument)">
				<xsl:value-of select="4"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="5"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- Wykorzystanie parametrów oraz dokumentów recept zgodnych z IG -->
	<xsl:template match="hl7:ClinicalDocument">
		<html>
			<head>
				<xsl:call-template name="styles"/>
			</head>
			<body>
				<div class="document">
					<xsl:call-template name="title"/>
					<div class="klucz_id">
						<xsl:call-template name="klucz"/>
						<xsl:call-template name="docRootId"/>
					</div>
					<div class="doc_header kod_time table">
						<xsl:call-template name="kod"/>
						<xsl:call-template name="effectiveTime"/>
					</div>
					<div class="doc_header border_top table">
						<xsl:call-template name="recordTarget"/>
						<xsl:call-template name="author"/>
						<xsl:call-template name="terminKontroli"/>
					</div>
					
					<xsl:call-template name="docBody">
						<xsl:with-param name="doc" select="$doc1/hl7:ClinicalDocument"/>
						<xsl:with-param name="docNr" select="$doc1Nr"/>
					</xsl:call-template>
					<xsl:call-template name="docBody">
						<xsl:with-param name="doc" select="$doc2/hl7:ClinicalDocument"/>
						<xsl:with-param name="docNr" select="$doc2Nr"/>
					</xsl:call-template>
					<xsl:call-template name="docBody">
						<xsl:with-param name="doc" select="$doc3/hl7:ClinicalDocument"/>
						<xsl:with-param name="docNr" select="$doc3Nr"/>
					</xsl:call-template>
					<xsl:call-template name="docBody">
						<xsl:with-param name="doc" select="$doc4/hl7:ClinicalDocument"/>
						<xsl:with-param name="docNr" select="$doc4Nr"/>
					</xsl:call-template>
					<xsl:call-template name="docBody">
						<xsl:with-param name="doc" select="$doc5/hl7:ClinicalDocument"/>
						<xsl:with-param name="docNr" select="$doc5Nr"/>
					</xsl:call-template>
					<xsl:call-template name="disclaimer"/>
				</div>
			</body>
		</html>
	</xsl:template>
	
	<!--
		Dane wyświetlane w ramach informacji o receptach:
		- klucz i kod dostępowy pakietu recept na podstawie zewnętrznych parametrów
		- dane wspólne o receptach w pakiecie na podstawie danych jednej z recept:
			- data wystawienia pakietu recept
			- imię i nazwisko pacjenta
			- imię i nazwisko osoby wystawiającej pakiet recept
			- numer prawa wykonywania zawodu osoby wystawiającej
			- numer telefonu do bezpośredniego kontaktu z osobą wystawiającą
			
		- dane poszczególnych dokumentów recept:
			- klucz dokumentu recepty na podstawie zewnętrznego parametru
			- id dokumentu recepty
			- narrative text sekcji zalecenia leku (Prescriptions), w tym:
				- nazwa leku
				- postać
				- dawka
				- ilość
				- sposób stosowania (do narrative block sekcji zalecenia leku włączono od 1.2.1 IG)
			- datę "realizacji od" konkretnej daty, jeżeli dotyczy
		
		- wskazany termin kontroli lekarskiej, jeżeli dotyczy, na podstawie zewnętrznego parametru o tekstowym typie
	-->

	<xsl:template name="docBody">
		<xsl:param name="doc"/>
		<xsl:param name="docNr"/>

		<xsl:if test="$doc">
			<div class="page_break_avoid">&#160;</div>
			<div class="doc_body">
				<div class="noScreen">
					<div id="footer">

					</div>
				</div>
				<xsl:call-template name="docTitle">
					<xsl:with-param name="docNr" select="$docNr"/>
					<xsl:with-param name="docId" select="$doc/hl7:id"/>
				</xsl:call-template>
				<div style="clear:both"/>
				<div class="section_text_1">
					<xsl:call-template name="prescriptions">
						<xsl:with-param name="doc" select="$doc"/>
					</xsl:call-template>
				</div>
			</div>
		</xsl:if>
	</xsl:template>
	
	<!-- tytuł informacji -->
	<xsl:template name="title">
		<span class="title">
			<img class="title_img" src="data:image/png;base64,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"/>
		</span>
		<xsl:choose>
			<xsl:when test="hl7:code/hl7:translation[@code='04.01']/hl7:qualifier/hl7:name[@code='RRECE']/../hl7:value[@code='PA']"> 
				<span class="title_suffix" style="font-style: italic">
					<xsl:text>pro auctore</xsl:text>
				</span>
			</xsl:when>
			<xsl:when test="hl7:code/hl7:translation[@code='04.01']/hl7:qualifier/hl7:name[@code='RRECE']/../hl7:value[@code='PF']"> 
				<span class="title_suffix" style="font-style: italic">
					<xsl:text>pro familiae</xsl:text>
				</span>
			</xsl:when>
			<xsl:when test="hl7:code/hl7:translation[@code='04.01']/hl7:qualifier/hl7:name[@code='RRECE']/../hl7:value[@code='TG']"> 
				<span class="title_suffix" style="font-style: italic">
					<xsl:text>transgraniczna</xsl:text>
				</span>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- nazwa dokumentu recepty -->
	<xsl:template name="docTitle">
		<xsl:param name="docNr"/>
		<xsl:param name="docId"/>
		
		<div class="section_title_left">
			<xsl:text>Recepta </xsl:text>
			<xsl:value-of select="$docNr"/>
			<xsl:text> z </xsl:text>
			<xsl:value-of select="$iloscRecept"/>
		</div>
		<div class="section_title_right">
			<xsl:value-of select="$docId/@extension"/>
		</div>
	</xsl:template>
	
	<!-- uwaga: uznano, że wszystkie recepty w pakiecie powinny mieć ten sam root identyfikatora! -->
	<xsl:template name="docRootId">
		<div class="header_element">
			<div class="doc_id">
				<xsl:text>Prefiks ID </xsl:text>
				<xsl:value-of select="$doc1/hl7:ClinicalDocument/hl7:id/@root"/>
			</div>
		</div>
	</xsl:template>
	
	<!-- klucz pakietu recept, wyeliminowano z użycia klucze poszczególnych recept -->
	<xsl:template name="klucz">
		<div class="klucz">
			<xsl:choose>
				<xsl:when test="$klucz and string-length($klucz) = 44">
					<xsl:variable name="barcodeWidth" select="277"/>
					
					<xsl:variable name="p1" select="number(substring($klucz, 1, 2))"/>
					<xsl:variable name="p2" select="number(substring($klucz, 3, 2))"/>
					<xsl:variable name="p3" select="number(substring($klucz, 5, 2))"/>
					<xsl:variable name="p4" select="number(substring($klucz, 7, 2))"/>
					<xsl:variable name="p5" select="number(substring($klucz, 9, 2))"/>
					<xsl:variable name="p6" select="number(substring($klucz, 11, 2))"/>
					<xsl:variable name="p7" select="number(substring($klucz, 13, 2))"/>
					<xsl:variable name="p8" select="number(substring($klucz, 15, 2))"/>
					<xsl:variable name="p9" select="number(substring($klucz, 17, 2))"/>
					<xsl:variable name="p10" select="number(substring($klucz, 19, 2))"/>
					<xsl:variable name="p11" select="number(substring($klucz, 21, 2))"/>
					<xsl:variable name="p12" select="number(substring($klucz, 23, 2))"/>
					<xsl:variable name="p13" select="number(substring($klucz, 25, 2))"/>
					<xsl:variable name="p14" select="number(substring($klucz, 27, 2))"/>
					<xsl:variable name="p15" select="number(substring($klucz, 29, 2))"/>
					<xsl:variable name="p16" select="number(substring($klucz, 31, 2))"/>
					<xsl:variable name="p17" select="number(substring($klucz, 33, 2))"/>
					<xsl:variable name="p18" select="number(substring($klucz, 35, 2))"/>
					<xsl:variable name="p19" select="number(substring($klucz, 37, 2))"/>
					<xsl:variable name="p20" select="number(substring($klucz, 39, 2))"/>
					<xsl:variable name="p21" select="number(substring($klucz, 41, 2))"/>
					<xsl:variable name="p22" select="number(substring($klucz, 43, 2))"/>
					
					<xsl:variable name="checksum" select="(105+$p1*1+$p2*2+$p3*3+$p4*4+$p5*5+$p6*6+$p7*7+$p8*8+$p9*9+$p10*10+$p11*11+$p12*12+$p13*13+$p14*14+$p15*15+$p16*16+$p17*17+$p18*18+$p19*19+$p20*20+$p21*21+$p22*22) mod 103"/>
					
					<div class="barcode">
						<xsl:choose>
							<xsl:when test="$SVG = 'enabled'">
								<!-- kod SVG niekompatybilny z IE8-, przy generowaniu wyniku należy podać parametr SVG=disabled by wykorzystać img zamiast SVG. Efekt może być mniej czytelny dla czytników kodów. -->
								<svg id="kluczSkierowania" xmlns="http://www.w3.org/2000/svg" width="{$barcodeWidth}" height="{$barcodeHeight}">
									<g transform="translate(0)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="'startC'"/>
										</xsl:call-template>
									</g>
									<g transform="translate(11)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p1"/>
										</xsl:call-template>
									</g>
									<g transform="translate(22)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p2"/>
										</xsl:call-template>
									</g>
									<g transform="translate(33)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p3"/>
										</xsl:call-template>
									</g>
									<g transform="translate(44)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p4"/>
										</xsl:call-template>
									</g>
									<g transform="translate(55)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p5"/>
										</xsl:call-template>
									</g>
									<g transform="translate(66)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p6"/>
										</xsl:call-template>
									</g>
									<g transform="translate(77)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p7"/>
										</xsl:call-template>
									</g>
									<g transform="translate(88)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p8"/>
										</xsl:call-template>
									</g>
									<g transform="translate(99)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p9"/>
										</xsl:call-template>
									</g>
									<g transform="translate(110)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p10"/>
										</xsl:call-template>
									</g>
									<g transform="translate(121)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p11"/>
										</xsl:call-template>
									</g>
									<g transform="translate(132)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p12"/>
										</xsl:call-template>
									</g>
									<g transform="translate(143)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p13"/>
										</xsl:call-template>
									</g>
									<g transform="translate(154)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p14"/>
										</xsl:call-template>
									</g>
									<g transform="translate(165)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p15"/>
										</xsl:call-template>
									</g>
									<g transform="translate(176)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p16"/>
										</xsl:call-template>
									</g>
									<g transform="translate(187)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p17"/>
										</xsl:call-template>
									</g>
									<g transform="translate(198)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p18"/>
										</xsl:call-template>
									</g>
									<g transform="translate(209)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p19"/>
										</xsl:call-template>
									</g>
									<g transform="translate(220)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p20"/>
										</xsl:call-template>
									</g>
									<g transform="translate(231)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p21"/>
										</xsl:call-template>
									</g>
									<g transform="translate(242)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$p22"/>
										</xsl:call-template>
									</g>
									<g transform="translate(253)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="$checksum"/>
										</xsl:call-template>
									</g>
									<g transform="translate(264)">
										<xsl:call-template name="drawBarSVG">
											<xsl:with-param name="code" select="'stopAndTerminate'"/>
										</xsl:call-template>
									</g>
								</svg>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="'startC'"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p1"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p2"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p3"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p4"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p5"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p6"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p7"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p8"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p9"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p10"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p11"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p12"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p13"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p14"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p15"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p16"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p17"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p18"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p19"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p20"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p21"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$p22"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="$checksum"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="'stop'"/>
								</xsl:call-template>
								<xsl:call-template name="drawBarIMG">
									<xsl:with-param name="code" select="'term'"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</div>
					<div class="klucz_value">
						<xsl:value-of select="$klucz"/>
					</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>Brak poprawnego klucza dokumentu</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</xsl:template>
	
	<!-- kod dostępu do pakietu recept -->
	<xsl:template name="kod">
		<div class="kod cell">
			<span class="kod_label row_label_inline">
				<xsl:text>Kod dostępu</xsl:text>
				<span class="kod_value emphasized">
					<xsl:choose>
						<xsl:when test="$kod and string-length($kod) &gt;= 1">
							<!-- ograniczenie tymczasowe wynikające z obsługi kodu w P1, planuje się wprowadzenie informacji o błędnym kodzie przy długości != 4 -->
							<xsl:variable name="kodPakietu4cyfry" select="substring($kod, 1, 4)"/>
							<xsl:value-of select="$kodPakietu4cyfry"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>brak kodu dostępu</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</span>
			</span>
		</div>
	</xsl:template>

	<!--	Przygotowuje komunikat dot. recepty 365-->
	<xsl:template name="komunikat-recepta-365">
		<xsl:param name="sa"/>

		<xsl:variable name="documentDate" select="substring(/hl7:ClinicalDocument/hl7:effectiveTime/@value, 1, 8)"/>
		<xsl:variable name="supplyDateLowValue" select="$sa//hl7:supply[hl7:templateId/@root = '2.16.840.1.113883.3.4424.13.10.4.55']/hl7:effectiveTime/@value"/>
		<xsl:variable name="supplyDateHighValue" select="$sa//hl7:supply[hl7:templateId/@root = '2.16.840.1.113883.3.4424.13.10.4.55']//hl7:supply[hl7:templateId/@root = '1.3.6.1.4.1.19376.1.9.1.3.15']/hl7:effectiveTime/hl7:high/@value"/>

		<xsl:variable name="dolnaData">
			<xsl:choose>
				<xsl:when test="$supplyDateLowValue">
					<xsl:value-of select="$supplyDateLowValue"/>
				</xsl:when>
				<xsl:when test="$documentDate">
					<xsl:value-of select="$documentDate"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="roznicaDat">
			<xsl:call-template name="oblicz-roznice-dat">
				<xsl:with-param name="data1" select="$dolnaData" />
				<xsl:with-param name="data2" select="$supplyDateHighValue" />
			</xsl:call-template>
		</xsl:variable>

		<xsl:if test="$roznicaDat = 365">
			<xsl:variable name="dataZPrzesunieciem">
				<xsl:call-template name="dodaj-dni-do-daty">
					<xsl:with-param name="data" select="$dolnaData"/>
					<xsl:with-param name="liczbaDni" select="30"/>
				</xsl:call-template>
			</xsl:variable>

			<div class="wykup-leku-info">
				<xsl:text>Do </xsl:text>
				<xsl:call-template name="formatDateTimeShortVariant">
					<xsl:with-param name="date" select="$dataZPrzesunieciem"/>
				</xsl:call-template>
				<xsl:text> wykup pierwsze opakowanie leku, żeby móc wykupić wszystkie przepisane opakowania. Jeśli zrobisz to później otrzymasz mniejszą ilość leku.</xsl:text>
			</div>
		</xsl:if>
	</xsl:template>

	<!--	Oblicz różnicę w dniach pomiędzy datami Gregorian Calendar-->
	<xsl:template name="oblicz-roznice-dat">
		<xsl:param name="data1"/>
		<xsl:param name="data2"/>
		<xsl:param name="julian-day1">
			<xsl:call-template name="gregorian-calendar-date-to-julian-day">
				<xsl:with-param name="date" select="$data1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="julian-day2">
			<xsl:call-template name="gregorian-calendar-date-to-julian-day">
				<xsl:with-param name="date" select="$data2" />
			</xsl:call-template>
		</xsl:param>
		<xsl:value-of select="$julian-day2 - $julian-day1"/>
	</xsl:template>

	<!--	Dodaje dni do daty Gregorian Calendar  -->
	<xsl:template name="dodaj-dni-do-daty">
		<xsl:param name="data"/>
		<xsl:param name="liczbaDni"/>

		<xsl:variable name="julianDay">
			<xsl:call-template name="gregorian-calendar-date-to-julian-day">
				<xsl:with-param name="date" select="$data" />
			</xsl:call-template>
		</xsl:variable>

		<xsl:variable name="dataGregorianCalendar">
			<xsl:call-template name="julian-day-to-gregorian-calendar-date">
				<xsl:with-param name="julian-day" select="$julianDay + $liczbaDni" />
			</xsl:call-template>
		</xsl:variable>

		<xsl:value-of select="$dataGregorianCalendar"/>
	</xsl:template>

	<!--	Konwertuje date Gregorian Calendar do julian day -->
	<xsl:template name="gregorian-calendar-date-to-julian-day">
		<xsl:param name="date"/>
		<xsl:param name="year" select="substring($date, 1, 4)"/>
		<xsl:param name="month" select="substring($date, 5, 2)"/>
		<xsl:param name="day" select="substring($date, 7, 2)"/>
		<xsl:param name="a" select="floor((14 - $month) div 12)"/>
		<xsl:param name="y" select="$year + 4800 - $a"/>
		<xsl:param name="m" select="$month + 12*$a - 3"/>
		<xsl:value-of select="$day + floor((153*$m + 2) div 5) + 365*$y + floor($y div 4) - floor($y div 100) + floor($y div 400) - 32045" />
	</xsl:template>

	<!--	Konwertuje julian day do daty Gregorian Calendar-->
	<xsl:template name="julian-day-to-gregorian-calendar-date">
		<xsl:param name="julian-day"/>

		<xsl:variable name="a" select="$julian-day + 32044"/>
		<xsl:variable name="b" select="floor((4 * $a + 3) div 146097)"/>
		<xsl:variable name="c" select="$a - 146097 * floor($b div 4)"/>

		<xsl:call-template name="gregorian-calendar-date-elem">
			<xsl:with-param name="b" select="$b"/>
			<xsl:with-param name="c" select="$c"/>
		</xsl:call-template>
	</xsl:template>

	<!-- Utils na potrzeby obliczenia Gregorian Calendar date -->
	<xsl:template name="gregorian-calendar-date-elem">
		<xsl:param name="b"/>
		<xsl:param name="c"/>

		<xsl:variable name="d" select="floor((4 * $c + 3) div 1461)"/>
		<xsl:variable name="e" select="$c - floor((1461 * $d) div 4)"/>
		<xsl:variable name="m" select="floor((5 * $e + 2) div 153)"/>

		<xsl:variable name="day"
					  select="$e - floor((153 * $m + 2) div 5) + 1"/>

		<xsl:variable name="month"
					  select="$m + 3 - (12 * floor($m div 10))"/>

		<xsl:variable name="year"
					  select="100 * $b + $d - 4800 + floor($m div 10)"/>

		<xsl:variable name="monthFormatted">
			<xsl:if test="string-length($month) = 2">
				<xsl:value-of select="$month"/>
			</xsl:if>
			<xsl:if test="string-length($month) = 1">
				<xsl:value-of select="concat('0',$month)"/>
			</xsl:if>
		</xsl:variable>

		<xsl:variable name="dayFormatted">
			<xsl:if test="string-length($day) = 2">
				<xsl:value-of select="$day"/>
			</xsl:if>
			<xsl:if test="string-length($day) = 1">
				<xsl:value-of select="concat('0',$day)"/>
			</xsl:if>
		</xsl:variable>

		<xsl:value-of select="concat($year, $monthFormatted, $dayFormatted)"/>
	</xsl:template>
	
	<!-- effectiveTime -->
	<xsl:template name="effectiveTime">
		<xsl:variable name="date" select="hl7:effectiveTime"/>
		
		<div class="effective_time header_element cell">
			<xsl:if test="$date">
				<span class="effective_time_label row_label_inline">
					<xsl:text>Wystawiono</xsl:text>
					<xsl:choose>
						<xsl:when test="$date/@nullFlavor">
							<xsl:call-template name="translateNullFlavor">
								<xsl:with-param name="nullableElement" select="$date"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:when test="$date/@value">
							<span class="effective_time_value row_value_inline">
								<xsl:call-template name="formatDateTimeShortVariant">
									<xsl:with-param name="date" select="$date/@value"/>
								</xsl:call-template>
							</span>
						</xsl:when>
						<xsl:when test="$date/hl7:low/@value and $date/hl7:high/@value">
							<span class="effective_time_value row_value_inline">
								<xsl:call-template name="formatDateTimeShortVariant">
									<xsl:with-param name="date" select="$date/hl7:low/@value"/>
								</xsl:call-template>
								<xsl:text> - </xsl:text>
								<xsl:call-template name="formatDateTimeShortVariant">
									<xsl:with-param name="date" select="$date/hl7:high/@value"/>
								</xsl:call-template>
							</span>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>(nie podano)</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</span>
			</xsl:if>
		</div>
	</xsl:template>
	
	<!-- zastrzeżenie dot. treści informacji o receptach elektronicznych -->
	<xsl:template name="disclaimer">
		<div class="header_element border_top">
			<div class="disclaimer">
				<div class="strona_ikp">
					Wejdź na <b>pacjent.gov.pl</b> i skorzystaj z Internetowego Konta Pacjenta (IKP).
				</div>
					<div class="oswiadczenie">
						Oświadczam, że nie realizowałem/am wcześniej recept o pozycjach: ...........<br/>
						Jestem świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.
						<div class="podpis">
							...................................................................
						</div>
						<div class="dataIMiejscowosc">
							(data i podpis)
						</div>
					</div>
			</div>
		</div>
	</xsl:template>
	
	<!-- sekcja główna dokumentu recepty -->
	<xsl:template name="prescriptions">
		<xsl:param name="doc"/>
		
		<!-- sekcja Prescriptions o różnym OID w zależności od rodzaju recepty, ze stałym kodem LOINC 57828-6 wykorzystanym do odnalezienia jej -->
		<xsl:variable name="prescriptions" select="$doc/hl7:component/hl7:structuredBody/hl7:component/hl7:section[hl7:code/@code='57828-6' and hl7:code/@codeSystem='2.16.840.1.113883.6.1']"/>
		<xsl:variable name="sa" select="$prescriptions/hl7:entry/hl7:substanceAdministration"/>
		<xsl:variable name="paymentLevels" select ="$sa/hl7:entryRelationship/hl7:supply/hl7:entryRelationship/hl7:act[hl7:templateId/@root = '2.16.840.1.113883.3.4424.13.10.4.57']"/>
		<xsl:variable name="entitlements" select ="$doc/hl7:component/hl7:structuredBody/hl7:component/hl7:section[hl7:templateId/@root='2.16.840.1.113883.3.4424.13.10.3.69']/hl7:entry[hl7:act[hl7:templateId/@root='2.16.840.1.113883.3.4424.13.10.4.51']/hl7:entryRelationship/hl7:act[hl7:templateId/@root='2.16.840.1.113883.3.4424.13.10.4.61']]"/>

		<xsl:call-template name="komunikat-recepta-365">
			<xsl:with-param name="sa" select="$sa"/>
		</xsl:call-template>
		<xsl:choose>
			<xsl:when test="($paymentLevels and count($paymentLevels) &gt; 0) or ($entitlements and count($entitlements) &gt; 0)">
				<div class="section_block">
					<div class="section_text_block">
						<xsl:call-template name="sectionTitle">
							<xsl:with-param name="tytulRecepty" select="$prescriptions/hl7:title"/>
						</xsl:call-template>
						<xsl:call-template name="sectionText">
							<xsl:with-param name="text" select="$prescriptions/hl7:text"/>
						</xsl:call-template>
					</div>
					<div class="payment_block">
						<xsl:for-each select="$paymentLevels">
							<xsl:call-template name="paymentBlock">
							<!-- Wartość refundacji -->
								<xsl:with-param name="text" select="./hl7:entryRelationship/hl7:act/hl7:code/hl7:qualifier/hl7:value/@code"/>
							</xsl:call-template>
						</xsl:for-each>
						<xsl:for-each select="$entitlements">
							<xsl:call-template name="paymentBlock">
								<!-- Dodatkowe uprawnienia -->
								<xsl:with-param name="text" select="./hl7:act/hl7:entryRelationship/hl7:act/hl7:code/hl7:qualifier/hl7:value/@code"/>
							</xsl:call-template>
						</xsl:for-each>
					</div>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="sectionTitle">
					<xsl:with-param name="tytulRecepty" select="$prescriptions/hl7:title"/>
				</xsl:call-template>
				<xsl:call-template name="sectionText">
					<xsl:with-param name="text" select="$prescriptions/hl7:text"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="paymentBlock">
		<xsl:param name="text"/>
		<div class="payment_text">
			<xsl:apply-templates select="$text"/>
		</div>
	</xsl:template>
	
	<xsl:template name="terminKontroli">
		<xsl:if test="$termin and string-length($termin) &gt;= 1">
			<div class="header_element row">
				<div class="row_label cell">
					<xsl:text>Termin kontroli</xsl:text>
				</div>
				<div class="row_value_bold cell">
					<xsl:value-of select="$termin"/>
				</div>
			</div>
		</xsl:if>
	</xsl:template>
	
	<!-- dane pacjenta -->
	<xsl:template name="recordTarget">
		<xsl:variable name="patientRole" select="hl7:recordTarget/hl7:patientRole"/>
		
		<div class="header_element row">
			<div class="row_label cell">
				<xsl:text>Pacjent</xsl:text>
			</div>
			<div class="row_value cell">
				<xsl:choose>
					<xsl:when test="hl7:recordTarget/@nullFlavor">
						<xsl:call-template name="translateNullFlavor">
							<xsl:with-param name="nullableElement" select="hl7:recordTarget"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$patientRole/@nullFlavor">
						<xsl:call-template name="translateNullFlavor">
							<xsl:with-param name="nullableElement" select="$patientRole"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<!-- imiona i nazwiska pacjenta -->
						<div class="emphasized">
							<xsl:call-template name="person">
								<xsl:with-param name="person" select="$patientRole/hl7:patient"/>
							</xsl:call-template>
						</div>
					</xsl:otherwise>
				</xsl:choose>
			</div>
		</div>
	</xsl:template>
	
	<!-- wystawca dokumentu, do wersji PIK 1.2 był to legalAuthenticator, od PIK 1.2.1 w związku z dostosowaniem do IHE PRE jest to author. PIK dopuszcza jednego autora recepty, alternatywnie asystenta i autora -->
	<xsl:template name="author">
		<xsl:variable name="assistant" select="/hl7:ClinicalDocument/hl7:dataEnterer/hl7:templateId/@root = '2.16.840.1.113883.3.4424.13.10.2.90' and 
										/hl7:ClinicalDocument/hl7:dataEnterer/hl7:assignedEntity/hl7:id/@extension = /hl7:ClinicalDocument/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id/@extension and 
										/hl7:ClinicalDocument/hl7:dataEnterer/hl7:assignedEntity/hl7:id/@root = /hl7:ClinicalDocument/hl7:legalAuthenticator/hl7:assignedEntity/hl7:id/@root"/>
		
		<xsl:choose>
			<xsl:when test="not($assistant)">
				<xsl:call-template name="assignedEntity">
					<xsl:with-param name="entity" select="hl7:author/hl7:assignedAuthor"/>
					<xsl:with-param name="blockLabel">Wystawca</xsl:with-param>
					<xsl:with-param name="knownIdentifiersOnly" select="true()"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="assignedEntity">
					<xsl:with-param name="entity" select="hl7:dataEnterer/hl7:assignedEntity"/>
					<xsl:with-param name="blockLabel">Wystawca</xsl:with-param>
					<xsl:with-param name="knownIdentifiersOnly" select="true()"/>
				</xsl:call-template>
				<xsl:call-template name="assignedEntity">
					<xsl:with-param name="entity" select="hl7:author/hl7:assignedAuthor"/>
					<xsl:with-param name="blockLabel">W imieniu</xsl:with-param>
					<xsl:with-param name="knownIdentifiersOnly" select="true()"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	
	<!-- ++++++++++++++++++++++++++++++++++++++ DRUGA LINIA +++++++++++++++++++++++++++++++++++++++++++-->
	
	<!-- osoba przypisana AssignedEntity templateId 2.16.840.1.113883.3.4424.13.10.2.49 -->
	<xsl:template name="assignedEntity">
		<xsl:param name="entity"/>
		<!-- kontekst domyślny -->
		<xsl:param name="context">assignedEntity</xsl:param>
		<xsl:param name="blockLabel">Blok danych</xsl:param>
		<xsl:param name="knownIdentifiersOnly" select="true()"/>
		
		<!-- maksymalna liczność assignedEntity to 1 -->
		<!-- id 1:*, code 0:1, addr 0:*, telecom 0:*, assignedPerson 0:1/1:1, representedOrganization 0:1 -->
		
		<div class="header_element row">
			<div class="row_label cell">
				<xsl:value-of select="$blockLabel"/>
			</div>
			<div class="row_value cell">
				<xsl:choose>
					<xsl:when test="not($entity)">
						<xsl:text>(nie podano informacji)</xsl:text>
					</xsl:when>
					<xsl:when test="$entity/@nullFlavor">
						<xsl:call-template name="translateNullFlavor">
							<xsl:with-param name="nullableElement" select="$entity"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$context = 'assignedEntity'">
						<xsl:call-template name="person">
							<xsl:with-param name="person" select="$entity/hl7:assignedPerson"/>
						</xsl:call-template>
						
						<xsl:call-template name="identifiersInDiv">
							<xsl:with-param name="ids" select="$entity/hl7:id"/>
							<xsl:with-param name="functionCode" select="$entity/parent::hl7:author/hl7:functionCode"/>
							<xsl:with-param name="knownOnly" select="$knownIdentifiersOnly"/>
						</xsl:call-template>
						
						<xsl:choose>
							<xsl:when test="$entity/hl7:telecom">
								<!-- dane kontaktowe przypisanego bytu -->
								<xsl:call-template name="addressTelecomInDivs">
									<xsl:with-param name="telecom" select="$entity/hl7:telecom"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<!-- jeśli nie podano danych przypisanego bytu, wyświetla się dane jego organizacji, o ile istnieją -->
								<xsl:call-template name="addressTelecomInDivs">
									<xsl:with-param name="telecom" select="$entity/hl7:representedOrganization/hl7:telecom"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>(nie podano informacji)</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</div>
		</div>
	</xsl:template>
	
	<!-- osoba templateId 2.16.840.1.113883.3.4424.13.10.2.1 -->
	<xsl:template name="person">
		<xsl:param name="person"/>
		
		<xsl:if test="$person">
			<xsl:choose>
				<xsl:when test="$person/@nullFlavor">
					<xsl:call-template name="translateNullFlavor">
						<xsl:with-param name="nullableElement" select="$person"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- imiona i nazwiska przypisanej osoby, brak innych istotnych danych w tym elemencie -->
					<xsl:call-template name="personName">
						<xsl:with-param name="name" select="$person/hl7:name"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<!-- imiona i nazwiska osoby z prefiksem i suffiksem, templateId 2.16.840.1.113883.3.4424.13.10.7.2 -->
	<xsl:template name="personName">
		<xsl:param name="name"/>
		
		<xsl:choose>
			<xsl:when test="not($name)">
				<xsl:call-template name="translateNullFlavor">
					<xsl:with-param name="nullableElement" select="$name"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- może istnieć wiele "nazw" osób, przy czym jedno imię i jedno nazwisko jest wymagane -->
				<xsl:for-each select="$name">
					<div class="row_value_element">
						<xsl:choose>
							<xsl:when test="./@nullFlavor">
								<xsl:call-template name="translateNullFlavor">
									<xsl:with-param name="nullableElement" select="."/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:if test="string-length(./hl7:prefix) &gt;= 1">
									<xsl:value-of select="./hl7:prefix"/>
									<xsl:text> </xsl:text>
								</xsl:if>
								<xsl:for-each select="./hl7:given">
									<xsl:choose>
										<xsl:when test="./@nullFlavor">
											<xsl:text>(imienia nie podano) </xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="."/>
											<xsl:text> </xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:for-each>
								<xsl:for-each select="./hl7:family">
									<xsl:choose>
										<xsl:when test="./@nullFlavor">
											<xsl:text>(nazwiska nie podano)</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="."/>
										</xsl:otherwise>
									</xsl:choose>
									<xsl:if test="position()!=last()">
										<xsl:text> </xsl:text>
									</xsl:if>
								</xsl:for-each>
								<xsl:if test="string-length(./hl7:suffix) &gt;= 1">
									<xsl:text> </xsl:text>
									<xsl:value-of select="./hl7:suffix"/>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</div>
				</xsl:for-each>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- pełna, sformatowana lista identyfikatorów typu II -->
	<xsl:template name="identifiersInDiv">
		<xsl:param name="ids"/>
		<xsl:param name="functionCode"/>
		<xsl:param name="knownOnly" select="false()"/>
		
		<xsl:variable name="displayableIds" select="$ids[not(@displayable='false')]"/>
		<xsl:variable name="count" select="count($displayableIds)"/>
		
		<xsl:if test="$count &gt; 0">
			<xsl:call-template name="listIdentifiersOID">
				<xsl:with-param name="ids" select="$displayableIds"/>
				<xsl:with-param name="functionCode" select="$functionCode"/>
				<xsl:with-param name="knownOnly" select="$knownOnly"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!--  lista identyfikatorów OID -->
	<xsl:template name="listIdentifiersOID">
		<xsl:param name="ids"/>
		<xsl:param name="functionCode"/>
		<xsl:param name="knownOnly" select="true()"/>
		
		<xsl:for-each select="$ids[not(@nullFlavor)]">
			<xsl:variable name="row">
				<xsl:call-template name="identifierOID">
					<xsl:with-param name="id" select="."/>
					<xsl:with-param name="functionCode" select="$functionCode"/>
					<xsl:with-param name="knownOnly" select="$knownOnly"/>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="string-length($row) &gt;= 1">
				<div class="row_value_element small">
					<xsl:value-of select="$row"/>
				</div>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<!--  identyfikator OID -->
	<xsl:template name="identifierOID">
		<xsl:param name="id"/>
		<xsl:param name="functionCode"/>
		<xsl:param name="knownOnly"/>
		
		<xsl:choose>
			<xsl:when test="not($id) or $id/@nullFlavor">
				<span class="null_flavor_id">
					<xsl:text>ID </xsl:text>
				</span>
				<xsl:call-template name="translateNullFlavor">
					<xsl:with-param name="nullableElement" select="$id"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="rootName">
					<xsl:call-template name="translateOID">
						<xsl:with-param name="oid" select="$id/@root"/>
						<xsl:with-param name="functionCode" select="$functionCode/@code"/>
					</xsl:call-template>
				</xsl:variable>
				
				<xsl:choose>
					<xsl:when test="$knownOnly">
						<!-- identyfikator nie jest wyświetlany gdy nie jest znany, a knownOnly = true -->
						<xsl:if test="string-length($rootName) &gt;= 1">
							<!-- bardzo robocze usunięcie numeru PESEL technika farm. gdyż ten szablon wykorzystuje się wyłącznie w przypadku id wystawcy -->
							<xsl:if test="$id/@root != '2.16.840.1.113883.3.4424.1.1.616'">
								<span>
									<xsl:value-of select="$rootName"/>
									<xsl:if test="string-length($id/@extension) &gt;= 1">
										<xsl:text> </xsl:text>
										<xsl:value-of select="$id/@extension"/>
									</xsl:if>
								</span>
							</xsl:if>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<span>
							<xsl:choose>
								<xsl:when test="string-length($rootName) &gt;= 1">
									<xsl:value-of select="$rootName"/>
								</xsl:when>
								<xsl:otherwise>
									<span class="not_known_id_prefix">
										<xsl:text>ID </xsl:text>
									</span>
									<xsl:value-of select="$id/@root"/>
									<xsl:if test="string-length($id/@assigningAuthorityName) &gt;= 1">
										<xsl:text> (</xsl:text>
										<xsl:value-of select="$id/@assigningAuthorityName"/>
										<xsl:text>)</xsl:text>
									</xsl:if>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:if test="string-length($id/@extension) &gt;= 1">
								<xsl:text> </xsl:text>
								<xsl:value-of select="$id/@extension"/>
							</xsl:if>
						</span>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- dane adresowe i kontaktowe -->
	<xsl:template name="addressTelecomInDivs">
		<xsl:param name="addr" select="false()"/>
		<xsl:param name="telecom" select="false()"/>
		
		<xsl:if test="$addr and count($addr) &gt; 0">
			<xsl:call-template name="addresses">
				<xsl:with-param name="addresses" select="$addr"/>
			</xsl:call-template>
		</xsl:if>
		
		<xsl:if test="$telecom and count($telecom) &gt; 0">
			<xsl:call-template name="telecoms">
				<xsl:with-param name="telecoms" select="$telecom"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!-- adresy -->
	<xsl:template name="addresses">
		<xsl:param name="addresses"/>
		
		<xsl:for-each select="$addresses">
			<div class="row_value_element address_element">
				<span class="address_label">
					<xsl:call-template name="translateAddressUseCode">
						<xsl:with-param name="useCode" select="./@use"/>
					</xsl:call-template>
				</span>
				<div class="address_value">
					<xsl:call-template name="address">
						<xsl:with-param name="addr" select="."/>
					</xsl:call-template>
				</div>
			</div>
		</xsl:for-each>
	</xsl:template>
	
	<!-- adres templateId 2.16.840.1.113883.3.4424.13.10.7.1 -->
	<xsl:template name="address">
		<xsl:param name="addr"/>
		
		<xsl:choose>
			<!-- wyświetlenie informacji o braku wyłącznie gdy podano nullFlavor na poziomie całego adresu -->
			<xsl:when test="$addr/@nullFlavor">
				<xsl:call-template name="translateNullFlavor">
					<xsl:with-param name="nullableElement" select="$addr"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- obsługiwane są wyłącznie podstawowe pola zdefiniowane w PL IG (bez unitType,
					 w którym za granicą wyróżnia się typ lokalu, np. appartment)
					 oraz pole streetAddressLine wspierające zapis adresów zagranicznych,
					 nie są wyświetlanie adresy wprowadzane w postaci nieanalitycznej, tzw. plain-text -->
				<xsl:if test="$addr/hl7:streetAddressLine or $addr/hl7:streetName or $addr/hl7:city or $addr/hl7:country">
					
					<!-- linie dla adresu zagranicznego, przy czym dopuszczalne jest stosowanie także innych elementów -->
					<xsl:for-each select="$addr/hl7:streetAddressLine">
						<div>
							<xsl:value-of select="."/>
						</div>
					</xsl:for-each>
					
					<!-- układ adresu polskiego, stosowanego także dla adresów zagranicznych z podanym city -->
					<xsl:if test="string-length($addr/hl7:city) &gt;= 1">
						<xsl:choose>
							<xsl:when test="string-length($addr/hl7:streetName) &gt;= 1">
								<!-- ulica, numer domu, numer mieszkania -->
								<div>
									<xsl:value-of select="$addr/hl7:streetName"/>
									<xsl:if test="string-length($addr/hl7:houseNumber) &gt;= 1">
										<xsl:text> </xsl:text>
										<xsl:value-of select="$addr/hl7:houseNumber"/>
										<xsl:if test="string-length($addr/hl7:unitID) &gt;= 1">
											<xsl:text> lok. </xsl:text>
											<xsl:value-of select="$addr/hl7:unitID"/>
										</xsl:if>
									</xsl:if>
								</div>
								<xsl:choose>
									<xsl:when test="not($addr/hl7:postalCode/@postCity) or $addr/hl7:postalCode/@postCity = $addr/hl7:city">
										<!-- adres z ulicą i miejscowością posiadającą pocztę
											ul. Stroma 120
											41-400 Równe -->
										<div>
											<xsl:if test="string-length($addr/hl7:postalCode) &gt;= 1">
												<xsl:value-of select="$addr/hl7:postalCode"/>
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="$addr/hl7:city"/>
										</div>
									</xsl:when>
									<xsl:otherwise>
										<!-- adres z ulicą, miejscowością i inną pocztą
											ul. Stroma 120
											Wygoniska
											Poczta: 41-400 Równe -->
										<div>
											<xsl:value-of select="$addr/hl7:city"/>
										</div>
										<div>
											<xsl:text>Poczta: </xsl:text>
											<xsl:if test="string-length($addr/hl7:postalCode) &gt;= 1">
												<xsl:value-of select="$addr/hl7:postalCode"/>
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="$addr/hl7:postalCode/@postCity"/>
										</div>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<!-- ulica nie istnieje w adresie -->
							<xsl:otherwise>
								<xsl:choose>
									<xsl:when test="not($addr/hl7:postalCode/@postCity) or $addr/hl7:postalCode/@postCity = $addr/hl7:city">
										<!-- adres bez ulicy, z miejscowością posiadającą pocztę
											41-400 Równe 120 -->
										<div>
											<xsl:if test="string-length($addr/hl7:postalCode) &gt;= 1">
												<xsl:value-of select="$addr/hl7:postalCode"/>
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="$addr/hl7:city"/>
											<xsl:if test="string-length($addr/hl7:houseNumber) &gt;= 1">
												<xsl:text> </xsl:text>
												<xsl:value-of select="$addr/hl7:houseNumber"/>
												<xsl:if test="string-length($addr/hl7:unitID) &gt;= 1">
													<xsl:text> lok. </xsl:text>
													<xsl:value-of select="$addr/hl7:unitID"/>
												</xsl:if>
											</xsl:if>
										</div>
									</xsl:when>
									<xsl:otherwise>
										<!-- adres bez ulicy, z miejscowością i inną pocztą
											Wygoniska 120
											41-400 Równe -->
										<div>
											<xsl:value-of select="$addr/hl7:city"/>
											<xsl:if test="string-length($addr/hl7:houseNumber) &gt;= 1">
												<xsl:text> </xsl:text>
												<xsl:value-of select="$addr/hl7:houseNumber"/>
												<xsl:if test="string-length($addr/hl7:unitID) &gt;= 1">
													<xsl:text> lok. </xsl:text>
													<xsl:value-of select="$addr/hl7:unitID"/>
												</xsl:if>
											</xsl:if>
										</div>
										<div>
											<xsl:text>Poczta: </xsl:text>
											<xsl:if test="string-length($addr/hl7:postalCode) &gt;= 1">
												<xsl:value-of select="$addr/hl7:postalCode"/>
												<xsl:text> </xsl:text>
											</xsl:if>
											<xsl:value-of select="$addr/hl7:postalCode/@postCity"/>
										</div>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
					
					<!-- kod teryt hl7:censusTract nie jest wyświetlany, powinien być obsługiwany elektronicznie -->
					
					<!-- kraj, region/stan nie jest wyświetlany -->
					<xsl:if test="string-length($addr/hl7:country) &gt;= 1">
						<div>
							<xsl:value-of select="$addr/hl7:country"/>
						</div>
					</xsl:if>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- dane kontaktowe -->
	<xsl:template name="telecoms">
		<xsl:param name="telecoms"/>
		
		<xsl:for-each select="$telecoms">
			<div class="row_value_element small">
				<xsl:call-template name="telecom">
					<xsl:with-param name="tele" select="."/>
				</xsl:call-template>
			</div>
		</xsl:for-each>
	</xsl:template>

	<!-- linia danych kontaktowych -->
	<xsl:template name="telecom">
		<xsl:param name="tele"/>
		
		<xsl:choose>
			<!-- wyświetlenie informacji o braku wyłącznie gdy podano nullFlavor -->
			<xsl:when test="$tele/@nullFlavor">
				<xsl:call-template name="translateNullFlavor">
					<xsl:with-param name="nullableElement" select="$tele"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- format <telecom use="PUB" value="tel: 22 2345 123"/> -->
				<xsl:variable name="address" select="substring-after($tele/@value, ':')"/>
				<xsl:variable name="protocol" select="substring-before($tele/@value, ':')"/>
				
				<xsl:choose>
					<xsl:when test="$address and $protocol">
						<xsl:call-template name="translateTelecomProtocolCode">
							<xsl:with-param name="protocolCode" select="$protocol"/>
						</xsl:call-template>
						
						<xsl:value-of select="$address"/>
						
						<xsl:if test="$tele/@use">
							<xsl:text> (</xsl:text>
							<xsl:call-template name="translateTelecomUseCode">
								<xsl:with-param name="useCode" select="$tele/@use"/>
							</xsl:call-template>
							<xsl:text>)</xsl:text>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<!-- dane w niepoprawnym formacie, są jednak wyświetlane -->
						<xsl:value-of select="$tele"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- źródło - HL7 V3 Data Types 2.19.2 Telecommunication Use Code -->
	<xsl:template name="translateTelecomUseCode">
		<xsl:param name="useCode"/>
		<xsl:choose>
			<xsl:when test="$useCode='H' or $useCode='HP'">
				<xsl:text>domowy</xsl:text>
			</xsl:when>
			<xsl:when test="$useCode='HV'">
				<xsl:text>podczas urlopu</xsl:text>
			</xsl:when>
			
			<xsl:when test="$useCode='WP'">
				<xsl:text>służbowy</xsl:text>
			</xsl:when>
			<xsl:when test="$useCode='DIR'">
				<xsl:text>służbowy bezpośredni</xsl:text>
			</xsl:when>
			<xsl:when test="$useCode='PUB'">
				<xsl:text>rejestracja</xsl:text>
			</xsl:when>
			
			<xsl:when test="$useCode='TMP'">
				<xsl:text>tymczasowy</xsl:text>
			</xsl:when>
			<xsl:when test="$useCode='EC'">
				<xsl:text>w nagłych przypadkach</xsl:text>
			</xsl:when>
			<xsl:when test="$useCode='MC'">
				<xsl:text>komórkowy</xsl:text>
			</xsl:when>
			
			<xsl:otherwise>
				<xsl:text>inny: </xsl:text>
				<xsl:value-of select="$useCode"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- źródło - HL7 V3 Data Types 2.18.1 Protocol Code -->
	<xsl:template name="translateTelecomProtocolCode">
		<xsl:param name="protocolCode"/>
		<xsl:choose>
			<xsl:when test="$protocolCode='fax'">
				<xsl:text>faks: </xsl:text>
			</xsl:when>
			<xsl:when test="$protocolCode='http'">
				<xsl:text>Internet: </xsl:text>
			</xsl:when>
			<xsl:when test="$protocolCode='mailto'">
				<xsl:text>e-mail: </xsl:text>
			</xsl:when>
			<xsl:when test="$protocolCode='tel'">
				<xsl:text>tel: </xsl:text>
			</xsl:when>
			<!-- pozostałe przypadki są nieistotne, będą jednak wyświetlane -->
			<xsl:otherwise>
				<xsl:text>inny: </xsl:text>
				<xsl:value-of select="$protocolCode"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- źródło - HL7 V3 Data Types 2.21.1 Postal Address Use Code -->
	<xsl:template name="translateAddressUseCode">
		<xsl:param name="useCode"/>
		<xsl:choose>
			<!-- podstawowy adres instytucji, biura lub pracy -->
			<xsl:when test="not($useCode) or $useCode='WP' or $useCode='DIR' or $useCode='PUB' or $useCode='PHYS'">
				<xsl:text>Adres</xsl:text>
			</xsl:when>
			
			<xsl:when test="$useCode='H' or $useCode='HP'">
				<xsl:text>Adres zamieszkania</xsl:text>
			</xsl:when>
			<xsl:when test="$useCode='HV'">
				<xsl:text>Adres w trakcie urlopu</xsl:text>
			</xsl:when>
			<xsl:when test="$useCode='TMP'">
				<xsl:text>Adres tymczasowy</xsl:text>
			</xsl:when>
			<xsl:when test="$useCode='PST'">
				<xsl:text>Adres korespondencyjny</xsl:text>
			</xsl:when>
			
			<xsl:otherwise>
				<xsl:text>Inny adres (</xsl:text>
				<xsl:value-of select="$useCode"/>
				<xsl:text>)</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	
	<!-- ++++++++++++++ obsługa kodów kreskowych code 128 zestaw C w SVG (ograniczenie IE9+) ++++++++++++++++ -->
	<xsl:template name="drawBarSVG">
		<xsl:param name="code"/>
		<xsl:choose>
			<xsl:when test="$code = 'startC'"><!-- 211232 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="1"/>
				<rect x="6" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 0"><!-- 212222 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="2"/>
				<rect x="7" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 1"><!-- 222122 -->
				<rect x="0" height="30" width="2"/>
				<rect x="4" height="30" width="2"/>
				<rect x="7" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 2"><!-- 222221 -->
				<rect x="0" height="30" width="2"/>
				<rect x="4" height="30" width="2"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 3"><!-- 121223 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="1"/>
				<rect x="6" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 4"><!-- 121322 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="1"/>
				<rect x="7" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 5"><!-- 131222 -->
				<rect x="0" height="30" width="1"/>
				<rect x="4" height="30" width="1"/>
				<rect x="7" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 6"><!-- 122213 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="2"/>
				<rect x="7" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 7"><!-- 122312 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="2"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 8"><!-- 132212 -->
				<rect x="0" height="30" width="1"/>
				<rect x="4" height="30" width="2"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 9"><!-- 221213 -->
				<rect x="0" height="30" width="2"/>
				<rect x="4" height="30" width="1"/>
				<rect x="7" height="30" width="1"/>
			</xsl:when>
			
			<xsl:when test="$code = 10"><!-- 221312 -->
				<rect x="0" height="30" width="2"/>
				<rect x="4" height="30" width="1"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 11"><!-- 231212 -->
				<rect x="0" height="30" width="2"/>
				<rect x="5" height="30" width="1"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 12"><!-- 112232 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="2"/>
				<rect x="6" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 13"><!-- 122132 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="2"/>
				<rect x="6" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 14"><!-- 122231 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="2"/>
				<rect x="7" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 15"><!-- 113222 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="3"/>
				<rect x="7" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 16"><!-- 123122 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="3"/>
				<rect x="7" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 17"><!-- 123221 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="3"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 18"><!-- 223211 -->
				<rect x="0" height="30" width="2"/>
				<rect x="4" height="30" width="3"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 19"><!-- 221132 -->
				<rect x="0" height="30" width="2"/>
				<rect x="4" height="30" width="1"/>
				<rect x="6" height="30" width="3"/>
			</xsl:when>
			
			<xsl:when test="$code = 20"><!-- 221231 -->
				<rect x="0" height="30" width="2"/>
				<rect x="4" height="30" width="1"/>
				<rect x="7" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 21"><!-- 213212 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="3"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 22"><!-- 223112 -->
				<rect x="0" height="30" width="2"/>
				<rect x="4" height="30" width="3"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 23"><!-- 312131 -->
				<rect x="0" height="30" width="3"/>
				<rect x="4" height="30" width="2"/>
				<rect x="7" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 24"><!-- 311222 -->
				<rect x="0" height="30" width="3"/>
				<rect x="4" height="30" width="1"/>
				<rect x="7" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 25"><!-- 321122 -->
				<rect x="0" height="30" width="3"/>
				<rect x="5" height="30" width="1"/>
				<rect x="7" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 26"><!-- 321221 -->
				<rect x="0" height="30" width="3"/>
				<rect x="5" height="30" width="1"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 27"><!-- 312212 -->
				<rect x="0" height="30" width="3"/>
				<rect x="4" height="30" width="2"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 28"><!-- 322112 -->
				<rect x="0" height="30" width="3"/>
				<rect x="5" height="30" width="2"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 29"><!-- 322211 -->
				<rect x="0" height="30" width="3"/>
				<rect x="5" height="30" width="2"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			
			<xsl:when test="$code = 30"><!-- 212123 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="2"/>
				<rect x="6" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 31"><!-- 212321 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="2"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 32"><!-- 232121 -->
				<rect x="0" height="30" width="2"/>
				<rect x="5" height="30" width="2"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 33"><!-- 111323 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="1"/>
				<rect x="6" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 34"><!-- 131123 -->
				<rect x="0" height="30" width="1"/>
				<rect x="4" height="30" width="1"/>
				<rect x="6" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 35"><!-- 131321 -->
				<rect x="0" height="30" width="1"/>
				<rect x="4" height="30" width="1"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 36"><!-- 112313 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="2"/>
				<rect x="7" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 37"><!-- 132113 -->
				<rect x="0" height="30" width="1"/>
				<rect x="4" height="30" width="2"/>
				<rect x="7" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 38"><!-- 132311 -->
				<rect x="0" height="30" width="1"/>
				<rect x="4" height="30" width="2"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 39"><!-- 211313 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="1"/>
				<rect x="7" height="30" width="1"/>
			</xsl:when>
			
			<xsl:when test="$code = 40"><!-- 231113 -->
				<rect x="0" height="30" width="2"/>
				<rect x="5" height="30" width="1"/>
				<rect x="7" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 41"><!-- 231311 -->
				<rect x="0" height="30" width="2"/>
				<rect x="5" height="30" width="1"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 42"><!-- 112133 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="2"/>
				<rect x="5" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 43"><!-- 112331 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="2"/>
				<rect x="7" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 44"><!-- 132131 -->
				<rect x="0" height="30" width="1"/>
				<rect x="4" height="30" width="2"/>
				<rect x="7" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 45"><!-- 113123 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="3"/>
				<rect x="6" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 46"><!-- 113321 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="3"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 47"><!-- 133121 -->
				<rect x="0" height="30" width="1"/>
				<rect x="4" height="30" width="3"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 48"><!-- 313121 -->
				<rect x="0" height="30" width="3"/>
				<rect x="4" height="30" width="3"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 49"><!-- 211331 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="1"/>
				<rect x="7" height="30" width="3"/>
			</xsl:when>
			
			<xsl:when test="$code = 50"><!-- 231131 -->
				<rect x="0" height="30" width="2"/>
				<rect x="5" height="30" width="1"/>
				<rect x="7" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 51"><!-- 213113 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="3"/>
				<rect x="7" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 52"><!-- 213311 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="3"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 53"><!-- 213131 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="3"/>
				<rect x="7" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 54"><!-- 311123 -->
				<rect x="0" height="30" width="3"/>
				<rect x="4" height="30" width="1"/>
				<rect x="6" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 55"><!-- 311321 -->
				<rect x="0" height="30" width="3"/>
				<rect x="4" height="30" width="1"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 56"><!-- 331121 -->
				<rect x="0" height="30" width="3"/>
				<rect x="6" height="30" width="1"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 57"><!-- 312113 -->
				<rect x="0" height="30" width="3"/>
				<rect x="4" height="30" width="2"/>
				<rect x="7" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 58"><!-- 312311 -->
				<rect x="0" height="30" width="3"/>
				<rect x="4" height="30" width="2"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 59"><!-- 332111 -->
				<rect x="0" height="30" width="3"/>
				<rect x="6" height="30" width="2"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			
			<xsl:when test="$code = 60"><!-- 314111 -->
				<rect x="0" height="30" width="3"/>
				<rect x="4" height="30" width="4"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 61"><!-- 221411 -->
				<rect x="0" height="30" width="2"/>
				<rect x="4" height="30" width="1"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 62"><!-- 431111 -->
				<rect x="0" height="30" width="4"/>
				<rect x="7" height="30" width="1"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 63"><!-- 111224 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="1"/>
				<rect x="5" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 64"><!-- 111422 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="1"/>
				<rect x="7" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 65"><!-- 121124 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="1"/>
				<rect x="5" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 66"><!-- 121421 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="1"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 67"><!-- 141122 -->
				<rect x="0" height="30" width="1"/>
				<rect x="5" height="30" width="1"/>
				<rect x="7" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 68"><!-- 141221 -->
				<rect x="0" height="30" width="1"/>
				<rect x="5" height="30" width="1"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 69"><!-- 112214 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="2"/>
				<rect x="6" height="30" width="1"/>
			</xsl:when>
			
			<xsl:when test="$code = 70"><!-- 112412 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="2"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 71"><!-- 122114 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="2"/>
				<rect x="6" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 72"><!-- 122411 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="2"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 73"><!-- 142112 -->
				<rect x="0" height="30" width="1"/>
				<rect x="5" height="30" width="2"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 74"><!-- 142211 -->
				<rect x="0" height="30" width="1"/>
				<rect x="5" height="30" width="2"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 75"><!-- 241211 -->
				<rect x="0" height="30" width="2"/>
				<rect x="6" height="30" width="1"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 76"><!-- 221114 -->
				<rect x="0" height="30" width="2"/>
				<rect x="4" height="30" width="1"/>
				<rect x="6" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 77"><!-- 413111 -->
				<rect x="0" height="30" width="4"/>
				<rect x="5" height="30" width="3"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 78"><!-- 241112 -->
				<rect x="0" height="30" width="2"/>
				<rect x="6" height="30" width="1"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 79"><!-- 134111 -->
				<rect x="0" height="30" width="1"/>
				<rect x="4" height="30" width="4"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			
			<xsl:when test="$code = 80"><!-- 111242 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="1"/>
				<rect x="5" height="30" width="4"/>
			</xsl:when>
			<xsl:when test="$code = 81"><!-- 121142 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="1"/>
				<rect x="5" height="30" width="4"/>
			</xsl:when>
			<xsl:when test="$code = 82"><!-- 121241 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="1"/>
				<rect x="6" height="30" width="4"/>
			</xsl:when>
			<xsl:when test="$code = 83"><!-- 114212 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="4"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 84"><!-- 124112 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="4"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 85"><!-- 124211 -->
				<rect x="0" height="30" width="1"/>
				<rect x="3" height="30" width="4"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 86"><!-- 411212 -->
				<rect x="0" height="30" width="4"/>
				<rect x="5" height="30" width="1"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 87"><!-- 421112 -->
				<rect x="0" height="30" width="4"/>
				<rect x="6" height="30" width="1"/>
				<rect x="8" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 88"><!-- 421211 -->
				<rect x="0" height="30" width="4"/>
				<rect x="6" height="30" width="1"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 89"><!-- 212141 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="2"/>
				<rect x="6" height="30" width="4"/>
			</xsl:when>
			
			<xsl:when test="$code = 90"><!-- 214121 -->
				<rect x="0" height="30" width="2"/>
				<rect x="3" height="30" width="4"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 91"><!-- 412121 -->
				<rect x="0" height="30" width="4"/>
				<rect x="5" height="30" width="2"/>
				<rect x="8" height="30" width="2"/>
			</xsl:when>
			<xsl:when test="$code = 92"><!-- 111143 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="1"/>
				<rect x="4" height="30" width="4"/>
			</xsl:when>
			<xsl:when test="$code = 93"><!-- 111341 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="1"/>
				<rect x="6" height="30" width="4"/>
			</xsl:when>
			<xsl:when test="$code = 94"><!-- 131141 -->
				<rect x="0" height="30" width="1"/>
				<rect x="4" height="30" width="1"/>
				<rect x="6" height="30" width="4"/>
			</xsl:when>
			<xsl:when test="$code = 95"><!-- 114113 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="4"/>
				<rect x="7" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 96"><!-- 114311 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="4"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 97"><!-- 411113 -->
				<rect x="0" height="30" width="4"/>
				<rect x="5" height="30" width="1"/>
				<rect x="7" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 98"><!-- 411311 -->
				<rect x="0" height="30" width="4"/>
				<rect x="5" height="30" width="1"/>
				<rect x="9" height="30" width="1"/>
			</xsl:when>
			<xsl:when test="$code = 99"><!-- 113141 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="3"/>
				<rect x="6" height="30" width="4"/>
			</xsl:when>
			
			<!-- trzy kody do zastosowania wyłącznie na potrzeby sumy kontrolnej -->
			<xsl:when test="$code = 100"><!-- 114131 -->
				<rect x="0" height="30" width="1"/>
				<rect x="2" height="30" width="4"/>
				<rect x="7" height="30" width="3"/>
			</xsl:when>
			<xsl:when test="$code = 101"><!-- 311141 -->
				<rect x="0" height="30" width="3"/>
				<rect x="4" height="30" width="1"/>
				<rect x="6" height="30" width="4"/>
			</xsl:when>
			<xsl:when test="$code = 102"><!-- 411131 -->
				<rect x="0" height="30" width="4"/>
				<rect x="5" height="30" width="1"/>
				<rect x="7" height="30" width="3"/>
			</xsl:when>
			
			<xsl:when test="$code = 'stopAndTerminate'"><!-- 2331112 -->
				<rect x="0" height="30" width="2"/>
				<rect x="5" height="30" width="3"/>
				<rect x="9" height="30" width="1"/>
				<rect x="11" height="30" width="2"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- ++++++++++++++ wariant dla IE8- obsługi kodów kreskowych code 128 zestaw C przy zastosowaniu bloków graficznych ++++++++++++++++ -->
	<xsl:template name="drawBarIMG">
		<xsl:param name="code"/>
		<xsl:choose>
			<xsl:when test="$code = 'startC'"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAvSURBVDhPY4CA////Q0gIAwJQuBAWitCoilEVoypGVUA4EBIhNKpiVAV9VPz/DwBnmvoibX9agwAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 'stop'"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA1SURBVDhP7cqxDQAgDMRA9l86KOGgp38XkfzxOtSFz/JuM9+GpwBPAZ4CPAV4CvAU4B9F1QbDhPoiW9BlugAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 'term'"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAIAAAAzCAIAAAAy8k57AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAOSURBVChTYxgFtAYMDAABZQABiqcCgwAAAABJRU5ErkJggg==" width="2" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 0"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAtSURBVDhP7cqhEQAwDMPA7r+0CuILMguV0AO9CVhUe3gE1R4eQbWHR1B9OeAD1PT6ImuabuUAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 1"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAApSURBVDhPY4CA/2AAZ8MZcPaoilEVoypGVYyqQOMgM+DsURX0VPH/PwBnmvoisR60VwAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 2"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAvSURBVDhP7cohDgAwDIDA/f/TXTKCm6sFdYJD8/oadGjQoUGHBh0adGjQocHmmLn6MfoiEpWL0AAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 3"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACnSURBVDhPTcexEcBAEINA99/0mfkAQbR8dK9C06bQtCk0bQpNm0LTptC0KTRtCk2bQtOm0LQpNG0KTZtC06bQtCk0bQpNm0LTptC0KTRtCk2bQtOm0LQpNG0KTZtC06bQtCk0bQpNm0LTptC0KTRtCk2bQtOm0LQpNG0KTZtC06bQtCk0bQpNm0LTptC0KTRtCk2bQtOm0LQpNG0KTZtC06bQtCn03f23DysO9xFdygAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 4"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAxSURBVDhP7YqxDQAwDIP6/9OunUhpL8gEE0Ico2LEpH6do3g+1mJSOTg4QioHx84hXUm1Kw7GxRTxAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 5"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA2SURBVDhP7YqxDQAgDMP4/+kQ1BaRjQPsybK8jIbrp75eZqJycHC0hJeZqBwcHC3hZSbq7yFtEwgrDu6JfY8AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 6"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAC1SURBVDhPVcixEYAAEIRA+2/6RUk4oh0eur9PsaC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5taC5tbi7FyR4Kw6yvVNQAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 7"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA1SURBVDhP7YpBCgAgEIT6/6enNQjp2nk8ibiGHLDrw9O1HlashxXrYcV6WLEeVqyHFfs5kg3tvCsOJj/7eAAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 8"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAqSURBVDhPYwCC/zAA4sC4yIxRFaMqQADEGVUxqmJUBQiAOKMqBoGK//8BgGIrDntzeXwAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 9"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA1SURBVDhP7YqxDQAgAIP8/+lK6OjoWiYSOCXyCth3VMC+owL2HRWw76iAfUcF7DsqYP86kguR0isOkRI0QAAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			
			<xsl:when test="$code = 10"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADhSURBVDhPTcjBEYAAEMJA+2/6BONk2FfgwX2M2LMcROxZDiL2LAcRe5aDiD3LQcSe5SBiz3IQsWc5iNizHETsWQ4i9iwHEXuWg4g9y0HEnuUgYs9yELFnOYjYsxxE7FkOIvYsBxF7loOIPctBxJ7lIGLPchCxZzmI2LMcROxZDiL2LAcRe5aDiD3LQcSe5SBiz3IQsWc5iNizHETsWQ4i9iwHEXuWg4g9y0HEnuUgYs9yELFnOYjYsxxE7FkOIvYsBxF7loOIPctBxJ7lIGLPchCxZzmI2LMcROxZDiL+vnsBWyUrDg3YTP8AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 11"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADNSURBVDhPTcfBEYAAEINA+2/6TAZlwmt56P70ojFJLxqT9KIxSS8ak/SiMUkvGpP0ojFJLxqT9KIxSS8ak/SiMUkvGpP0ojFJLxqT9KIxSS8ak/SiMUkvGpP0ojFJLxqT9KIxSS8ak/SiMUkvGpP0ojFJLxqT9KIxSS8ak/SiMUkvGpP0ojFJLxqT9KIxSS8ak/SiMUkvGpP0ojFJLxqT9KIxSS8ak/SiMUkvGpP0ojFJLxqT9KIxSS8ak/SiMUkvGpP0ojFJLxqT9Ie7FyR4Kw4yehscAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 12"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACsSURBVDhPRcixAYAADMMw/n+6gIfISxs9X3f3n579X+YUlTlFZU5RmVNU5hSVOUVlTlGZU1TmFJU5RWVOUZlTVOYUlTlFZU5RmVNU5hSVOUVlTlGZU1TmFJU5RWVOUZlTVOYUlTlFZU5RmVNU5hSVOUVlTlGZU1TmFJU5RWVOUZlTVOYUlTlFZU5RmVNU5hSVOUVlTlGZU1TmFJU5RWVOUZlTVOYUlTlF9Y+7FzDt+iInAwR3AAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 13"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAySURBVDhP7cohDgAwDMPA/f/TWdeByrTYQafIp5beU/ujNv/IgrKgLCgLyoKyoDZFcgHDhPoiqUmvwAAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 14"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACqSURBVDhPVcixDcMAEMSw7L/0RzauoFUR+tW9Pfq6Zq+u2atr9uqavbpmr67Zq2v26pq9umavrtmra/bqmr26Zq+u2atr9uqavbpmr67Zq2v26pq9umavrtmra/bqmr26Zq+u2atr9uqavbpmr67Zq2v26pq9umavrtmra/bqmr26Zq+u2atr9uqavbpmr67Zq2v26pq9umavrtmra/bqmr26Zq+u2avr7v4fffoiQpfoZQAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 15"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA3SURBVDhP7YqxDQAwDIP6/9Nu6BDWHmCWOIgzJOE8Zu/rXjVoW4C2BWhbgLYFaFuAtgVof4vkAp5H+iKF1IRWAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 16"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACdSURBVDhPRcixEcAwAISw7L+0Y1O8qHR8t1NPNftUs081+1SzTzX7VLNPNftUs081+1SzTzX7VLNPNftUs081+1SzTzX7VLNPNftUs081+1SzTzX7VLNPNftUs081+1SzTzX7VLNPNftUs081+1SzTzX7VLNPNftUs081+1SzTzX7VLNPNftUs081+1SzTzX7VLNPNftUs081v3vOD/ox+iKFu4oIAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 17"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAC2SURBVDhPTcixEYAAEIRA+2/6ReeCJQKeuJ/PfsyJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8yJK8y7ewGM1/oiT0gpuAAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 18"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACkSURBVDhPTcixDcMAEMSw7L/0B7AMntWJv7qndz47RGWHqOwQlR2iskNUdojKDlHZISo7RGWHqOwQlR2iskNUdojKDlHZISo7RGWHqOwQlR2iskNUdojKDlHZISo7RGWHqOwQlR2iskNUdojKDlHZISo7RGWHqOwQlR2iskNUdojKDlHZISo7RGWHqOwQlR2iskNUdojKDlHZISo7RGWHqOzd/QFnmvoiskMAyAAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 19"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAtSURBVDhPY4CA/2AAYUBEgAAuiMJBCI2qGFUxqmJUBTIHITSqYlQFfVT8/w8AMO36Io4VCMgAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			
			<xsl:when test="$code = 20"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACcSURBVDhPTcnBCYAAEMRA+2/6BAOz5jWQp+7rj5oNqNmAmg2o2YCaDajZgJoNqNmAmg2o2YCaDajZgJoNqNmAmg2o2YCaDajZgJoNqNmAmg2o2YCaDajZgJoNqNmAmg2o2YCaDajZgJoNqNmAmg2o2YCaDajZgJoNqNmAmg2o2YCaDajZgJoNqNmAmg2o2YCaDajZgJoNqNmAursXjNf6Ij9gEssAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 21"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA0SURBVDhP7cqxDQAgEMNA9l86yDzCNX1cXaSsKcnV8cwHUn2Q6oNUH6T6INUHqT5IfT+SDUJd+iJlNdLKAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 22"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAuSURBVDhPY4CA/2AA5YC5EBIhiMIZVTGqYlTFqIpRFSAAYaMIonBGVdBWxf//AJ5H+iIn18oCAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 23"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAtSURBVDhPY4CD////ozGAAJk9qmJUBQoDCEZVjKqAglEVoyqQGUBAJxX//wMAqrzJRXCBcAQAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 24"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAC+SURBVDhPXchBCoAAEMNA///plRKQwRxK0ufj7trk56Pw1Ufhq4/CVx+Frz4KX30UvvoofPVR+Oqj8NVH4auPwlcfha8+Cl99FL76KHz1Ufjqo/DVR+Grj8JXH4WvPgpffRS++ih89VH46qPw1Ufhq4/CVx+Frz4KX30UvvoofPVR+Oqj8NVH4auPwlcfha8+Cl99FL76KHz1Ufjqo/DVR+Grj8JXH4WvPgpffRS++ih89VH46qPw1UfhO7t7AQuw+iJ9IIe8AAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 25"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACdSURBVDhPXcgxDgAgEMMw/v/pQ0DkgUytl+b2xiflU1I+JeVTUj4l5VNSPiXlU1I+JeVTUj4l5VNSPiXlU1I+JeVTUj4l5VNSPiXlU1I+JeVTUj4l5VNSPiXlU1I+JeVTUj4l5VNSPiXlU1I+JeVTUj4l5VNSPiXlU1I+JeVTUj4l5VNSPiXlU1I+JeVTUj4l5VNSPiXlU1I+PX9mA9T0+iIuo1TtAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 26"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAC7SURBVDhPTcnBCYAAEMRA+2/6ZA0M5jWQR/f1Rw7LgByWATksA3JYBuSwDMhhGZDDMiCHZUAOy4AclgE5LANyWAbksAzIYRmQwzIgh2VADsuAHJYBOSwDclgG5LAMyGEZkMMyIIdlQA7LgByWATksA3JYBuSwDMhhGZDDMiCHZUAOy4AclgE5LANyWAbksAzIYRmQwzIgh2VADsuAHJYBOSwDclgG5LAMyGEZkMMyIIdlQA7LgByWAfPdC2ea+iKrwN/VAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 27"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAChSURBVDhPPcnBCQAgAMNA91+6IobLpwk92Ea+kxAOEsJBQjhICAcJ4SAhHCSEg4RwkBAOEsJBQjhICAcJ4SAhHCSEg4RwkBAOEsJBQjhICAcJ4SAhHCSEg4RwkBAOEsJBQjhICAcJ4SAhHCSEg4RwkBAOEsJBQjhICAcJ4SAhHCSEg4RwkBAOEsJBQjhICAcJ4SAhHCSEg4RwkBAOEsLxZrt5CvoiVddVUQAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 28"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAC2SURBVDhPXcjBCcBAAITA9N/0BbNwDPGlPpfzcf13wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp54wp7U57wLsPoiIww3uwAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 29"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACoSURBVDhPXcixCcAAEMSw7L/0h0shTFwZPbqv35NF+2TRPlm0Txbtk0X7ZNE+WbRPFu2TRftk0T5ZtE8W7ZNF+2TRPlm0Txbtk0X7ZNE+WbRPFu2TRftk0T5ZtE8W7ZNF+2TRPlm0Txbtk0X7ZNE+WbRPFu2TRftk0T5ZtE8W7ZNF+2TRPlm0Txbtk0X7ZNE+WbRPFu2TRftk0T5ZtE8W7ZNF+2TR/t291PT6IiGD028AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			
			<xsl:when test="$code = 30"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAuSURBVDhP7YohDgAgAIT8/6fPwEhGKyTYOLDtFSA7hOwQskPIDiE7hOwQ8ufYLkJd+iK/9jbIAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 31"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAxSURBVDhP7YqxDQAgAIP8/+k6EHzAFSZIOLDtCbxEOkykw0Q6TKTDRDpMpMNEfo7tAmea+iLhoFOOAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 32"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAtSURBVDhPY4CA/zAA56IxRlWgMkZVoDJGVaAyRlWgMkZVoDJGVaAyKFHx/z8AjNf6IsKVWJkAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 33"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA2SURBVDhP7YoxEgAwCML6/09TBSY2dzLohcsbAOiKnUL15MNOLVoQS04tWhBLTi1aEEtOhwL47bwrDn/PgokAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 34"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAzSURBVDhP7YohDgAgEID8/6dPGTPYjZAYYx3mopPe2NEBOqkDdFIH6KQO0EkdoJO+HjMbgGIrDsiP800AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 35"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACjSURBVDhPXcfBEYAwAIRA+2866uzlAx/g+TiXtJ2QthPSdkLaTkjbCWk7IW0npO2EtJ2QthPSdkLaTkjbCWk7IW0npO2EtJ2QthPSdkLaTkjbCWk7IW0npO2EtJ2QthPSdkLaTkjbCWk7IW0npO2EtJ2QthPSdkLaTkjbCWk7IW0npO2EtJ2QthPSdkLaTkjbCWk7IW0npO2EtJ2QthPS/57zAqWfKw4lR3rOAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 36"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAxSURBVDhP7cohAgAwDMLA/f/TbC0o7GwwnMh5kzS38MoUFIFXpqAIvDIFReCVPwvpApHSKw6odRI+AAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 37"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAvSURBVDhPYwCC/zAA4oC56IJQ5qgKIIAKQQCIM6piVMWoChAAcUZVjKqgs4r//wG3DysONTksLgAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 38"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAABCSURBVDhP7YrBDcAwEMKy/9KXBiuPeoNI+IEwYn3M5chfyT4C3ZOU7CPQPUnJPgLdk5TsI9A9Sck+At2TlHziMbMBSbUrDnki2W8AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 39"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADPSURBVDhPXcjBCQBBEALByz/pOaUeC9ZDGj/uzjJdyhXTpVwxXcoV06VcMV3KFdOlXDFdyhXTpVwxXcoV06VcMV3KFdOlXDFdyhXTpVwxXcoV06VcMV3KFdOlXDFdyhXTpVwxXcoV06VcMV3KFdOlXDFdyhXTpVwxXcoV06VcMV3KFdOlXDFdyhXTpVwxXcoV06VcMV3KFdOlXDFdyhXTpVwxXcoV06VcMV3KFdOlXDFdyhXTpVwxXcoV06VcMV3KFdOlXDFdyhXTpVzx+u4HyH8rDlZPpH4AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			
			<xsl:when test="$code = 40"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA4SURBVDhP7YqxAQAgDML8/2lEUhdXVzKVJgt04X4+h1kt4lswTXwLpolvwTTxLZgmvgXTxH8V0gZbJSsOUa1MPgAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 41"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA2SURBVDhP7YqxDQAwDIP6/9OpBeqUsauZkODIPLbTewSd3iPo9B5Bp/cIOr1H0Ok9gk7/OmYu7bwrDruDQ/YAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 42"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA6SURBVDhP7YqxAQAgDML8/2ksmKGzM1laIGeQ5LOeYf4HIWWNGpDVEFLWqAFZDSFljRqQ1RBS/hnSBdT0+iLiHA0HAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 43"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAEnSURBVDhPPclBEgBADAHB/f+nsxilL0Ge3J1PAqjSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKs2b8jWqNG/K16jSvClfo0rzpnyNKnf3AYzX+iJcTrvgAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 44"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA7SURBVDhP7YqxAQAgDIP8/+lYUA9wD1MLWUMePL7nGO5tBWUXVlB2YQVlF1ZQdmEFZRdWUHZhBeXvItmyFPoi5EQnfQAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 45"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAEOSURBVDhPPYlBEoAAEIL6/6e3IAcuoj4fd0dI/snPiiPkvrDiCLkvrDhC7gsrjpD7wooj5L6w4gi5L6w4Qu4LK46Q+8KKI+S+sOIIuS+sOELuCyuOkPvCiiPkvrDiCLkvrDhC7gsrjpD7wooj5L6w4gi5L6w4Qu4LK46Q+8KKI+S+sOIIuS+sOELuCyuOkPvCiiPkvrDiCLkvrDhC7gsrjpD7wooj5L6w4gi5L6w4Qu4LK46Q+8KKI+S+sOIIuS+sOELuCyuOkPvCiiPkvrDiCLkvrDhC7gsrjpD7wooj5L6w4gi5L6w4Qu4LK46Q+8KKI+S+sOIIuS+sOELuCyuOkPvCiiPkvrDiCLnv3d0LC7D6IkKWeSkAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 46"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADYSURBVDhPTcnBDcQAEMLA67/pvdiJkOcDiN/j7gg9/bWZkC82E/LFZkK+2EzIF5sJ+WIzIV9sJuSLzYR8sZmQLzYT8sVmQr7YTMgXmwn5YjMhX2wm5IvNhHyxmZAvNhPyxWZCvthMyBebCfliMyFfbCbki82EfLGZkC82E/LFZkK+2EzIF5sJ+WIzIV9sJuSLzYR8sZmQLzYT8sVmQr7YTMgXmwn5YjMhX2wm5IvNhHyxmZAvNhPyxWZCvthMyBebCfliMyFfbCbki82EfLGZkC82E/LFN+/+MO36IsedAuUAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 47"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAEASURBVDhPPclBEoAADINA///pKkxkTzR9PvfjUL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRL3wC0fUC79wRH13L+jB+iJ69fv4AAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 48"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAArSURBVDhPY4CD////Q1lIbGTBURWjKqBgVMWoCmQGCIyqGFUBAfRW8f8/AOFpyUWfTfHuAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 49"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAEOSURBVDhPRcnBDQAwDMLA7r90avCDe0QWebo7rxyxtvoNR6ytfsMRa6vfcMTa6jccsbb6DUesrX7DEWur33DE2uo3HLG2+g1HrK1+wxFrq99wxNrqNxyxtvoNR6ytfsMRa6vfcMTa6jccsbb6DUesrX7DEWur33DE2uo3HLG2+g1HrK1+wxFrq99wxNrqNxyxtvoNR6ytfsMRa6vfcMTa6jccsbb6DUesrX7DEWur33DE2uo3HLG2+g1HrK1+wxFrq99wxNrqNxyxtvoNR6ytfsMRa6vfcMTa6jccsbb6DUesrX7DEWur33DE2uo3HLG2+g1HrK1+wxFrq99wxNrqNxyxtvoNR6ytfsMRd/cBw4T6IiYFQ/cAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			
			<xsl:when test="$code = 50"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAEGSURBVDhPRcnBDcBAEMLA9N/0xmCdmJcFn+6xHbHuG7Yj1n3DdsS6b9iOWPcN2xHrvmE7Yt03bEes+4btiHXfsB2x7hu2I9Z9w3bEum/Yjlj3DdsR675hO2LdN2xHrPuG7Yh137Adse4btiPWfcN2xLpv2I5Y9w3bEeu+YTti3TdsR6z7hu2Idd+wHbHuG7Yj1n3DdsS6b9iOWPcN2xHrvmE7Yt03bEes+4btiHXfsB2x7hu2I9Z9w3bEum/Yjlj3DdsR675hO2LdN2xHrPuG7Yh137Adse4btiPWfcN2xLpv2I5Y9w3bEeu+YTti3TdsR6z7hu2Idd+wHbHuG7Yj1n3DdsTd/VYq+iJENo2YAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 51"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAzSURBVDhP7YrBCQAxAINu/6VzBesE/eojBPGDbff5zwKyQpAVgqwQZIUgKwRZIciXYvsBeQr6IgY/jHEAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 52"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA1SURBVDhP7YrBDQAwEIK6/9I2ihvcV15EeSCpFgecccWKktfgjCtWlLwGZ1yxouQ1OOOlkD4LsPoisb71OgAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 53"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAsSURBVDhPY4CA////Q1m42KMqQGBUxagKVNaoClTWqApU1qgKVBYNVPz/DwB0D8lFJBaRNAAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 54"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAD/SURBVDhPPYlBCgAwDIP2/093GEEPpZoXd9f1ERWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltBRWU0lZQQSltvbv7eQr6IqDk8IwAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 55"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADuSURBVDhPTcnBCQBBEALByz/pObSbxXoI6vfcHYkdRekbO4rSN3YUpW/sKErf2FGUvrGjKH1jR1H6xo6i9I0dRekbO4rSN3YUpW/sKErf2FGUvrGjKH1jR1H6xo6i9I0dRekbO4rSN3YUpW/sKErf2FGUvrGjKH1jR1H6xo6i9I0dRekbO4rSN3YUpW/sKErf2FGUvrGjKH1jR1H6xo6i9I0dRekbO4rSN3YUpW/sKErf2FGUvrGjKH1jR1H6xo6i9I0dRekbO4rSN3YUpW/sKErf2FGUvrGjKH1jR1H6xo6i9I0dRekbO4rSNxzvfp5H+iLDNuZhAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 56"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAD5SURBVDhPPcnBEYAAEINA+2/6HIKyLyZ5cj+70cBe2I0G9sJuNLAXdqOBvbAbDeyF3WhgL+xGA3thNxrYC7vRwF7YjQb2wm40sBd2o4G9sBsN7IXdaGAv7EYDe2E3GtgLu9HAXtiNBvbCbjSwF3ajgb2wGw3shd1oYC/sRgN7YTca2Au70cBe2I0G9sJuNLAXdqOBvbAbDeyF3WhgL+xGA3thNxrYC7vRwF7YjQb2wm40sBd2o4G9sBsN7IXdaGAv7EYDe2E3GtgLu9HAXtiNBvbCbjSwF3ajgb2wGw3shd1oYC/sRgN7YTca2Au70cBe2I0G9sL+xrsXMO36Isaa3d4AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 57"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAEOSURBVDhPTYnBDcAAEIK6/9LXIgkpD4P6xN395UtxhIqyFxyhouwFR6goe8ERKspecISKshccoaLsBUeoKHvBESrKXnCEirIXHKGi7AVHqCh7wREqyl5whIqyFxyhouwFR6goe8ERKspecISKshccoaLsBUeoKHvBESrKXnCEirIXHKGi7AVHqCh7wREqyl5whIqyFxyhouwFR6goe8ERKspecISKshccoaLsBUeoKHvBESrKXnCEirIXHKGi7AVHqCh7wREqyl5whIqyFxyhouwFR6goe8ERKspecISKshccoaLsBUeoKHvBESrKXnCEirIXHKGi7AVHqCh7wREqyl5whIqyFxyhouy9u3sBr7f6Igm9BoEAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 58"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADhSURBVDhPTcnJCQBBEMPAzT/pXuQBoXr5+HR3hqcjLHvREZa96AjLXnSEZS86wrIXHWHZi46w7EVHWPaiIyx70RGWvegIy150hGUvOsKyFx1h2YuOsOxFR1j2oiMse9ERlr3oCMtedIRlLzrCshcdYdmLjrDsRUdY9qIjLHvREZa96AjLXnSEZS86wrIXHWHZi46w7EVHWPaiIyx70RGWvegIy150hGUvOsKyFx1h2YuOsOxFR1j2oiMse9ERlr3oCMtedIRlLzrCshcdYdmLjrDsRUdY9qIjLHvREZa9IN/9Ql36ItvE898AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 59"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADHSURBVDhPPclBCgBBEAKx/f+ne1Gc5FAgftxj6vQNU6dvmDp9w9TpG6ZO3zB1+oap0zdMnb5h6vQNU6dvmDp9w9TpG6ZO3zB1+oap0zdMnb5h6vQNU6dvmDp9w9TpG6ZO3zB1+oap0zdMnb5h6vQNU6dvmDp9w9TpG6ZO3zB1+oap0zdMnb5h6vQNU6dvmDp9w9TpG6ZO3zB1+oap0zdMnb5h6vQNU6dvmDp9w9TpG6ZO3zB1+oap0zdMnb5h6vQNU6dvmOndD2ea+iIunjDaAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			
			<xsl:when test="$code = 60"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAApSURBVDhPY4CD////Q1lgAOGiCI6qGFUBB6MqRlWMqoCBURUDqOL/fwAYJclFMxVUcAAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 61"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA3SURBVDhP7YqxDQAwAIL6/9PWQNIHusqkgSOBN8SLX1G8+BXFi19RvPgVxYtfUbz4FcWL/yqSCyR4Kw5tjw/JAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 62"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADVSURBVDhPTclBCsAAEMLA/v/TW2Kodg5B8Pm7j7udvHC3kxfudvLC3U5euNvJC3c7eeFuJy/c7eSFu528cLeTF+528sLdTl6428kLdzt54W4nL9zt5IW7nbxwt5MX7nbywt1OXrjbyQt3O3nhbicv3O3khbudvHC3kxfudvLC3U5euNvJC3c7eeFuJy/c7eSFu528cLeTF+528sLdTl6428kLdzt54W4nL9zt5IW7nbxwt5MX7nbywt1OXrjbyQt3O3nhbicv3O3khbudvHC3kxduevcCC7D6Iq+f8nQAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 63"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA4SURBVDhP7Yq5DQAwEMKy/9IkiKdPj4vTGfk8AOjq6S/sXekrVgR7V/qKFcHelb5iRbB3pf8VwAVbJSsOtbNJZwAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 64"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA4SURBVDhP7YqxDQAwCMP6/9NpLShZOSAeELF8HpLqDthv+ptdYFMYbAqDTWGwKQw2hcGmMNhtIV2AYisOAo/1MAAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 65"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA2SURBVDhP7YoxEgAgDIP8/6ejtfSc3ckEOdZZ7hrK5+k9byi3gHALCLeAcAsIt4BwCwj/K5INJHgrDiZsdngAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 66"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA5SURBVDhP7YrBEQAgDMLcf2k0xZOvA5BPuSbroOENg5jPPV4eBtEiIFoERIuAaBEQLQKiRUB8FdIG3EwrDuVieEkAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 67"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA7SURBVDhP7YrBDQAgEIPcf+kqIeZ8OkB5FdJ1yINKvX2WqNQ+QKX2ASq1D1CpfYBK7QNUah+gUn8fyQbcTCsO+kWOsgAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 68"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA4SURBVDhP7YrBDQAgEMLcf2kUuTQ+HYB+gNB10APTx+0TwPRRo0YCmD5q1EgA00eNGglg+vgypA1u8isOlZM9jQAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 69"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA6SURBVDhP7YqxDQAgAML8/2mkwgXOdClJOUYSeiM7IzSgPUwD2sM0oD1MA9rDNKA9TAPawzSgz4d0Ach/Kw7eAWhOAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			
			<xsl:when test="$code = 70"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA3SURBVDhP7YqxDQAwDML6/9M0NMgHdIYFI3wmklwPCDOHq8ZCjRoBwszhqrFQo0aAMHO4Pg3pAlslKw5OPIVrAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 71"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA1SURBVDhP7cqxDQAgDMRA9l86QDhlAOp3ZVleh2qutU95qCyHynKoLIfKcqgsh8pyqOznqNpbJSsOIoUfPgAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 72"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA2SURBVDhP7YoxDgAgEIP8/6ereDHszu1ECessd9Dj2Vwt1EILtdBCLbRQCy3UQgu10EI/RbIBtw8rDkudv70AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 73"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA0SURBVDhP7YoxDgAgDIT8/6drMabn6g4bhNXUA37K9OsD7hFwj4B7BNwj4B4B9wj431G1ARMIKw44CUNtAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 74"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA0SURBVDhP7YoxDgAgEIP8/6er5GJwdS9TaViHPOD3maEPeAvBWwjeQvAWgrcQvIXgf0WyAdxMKw6YQ3CeAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 75"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAzSURBVDhP7YoxCgAwDIT6/0+nYEC6d/UmDz27eeZdwFcI+AoBXyHgKwR8hYCvEPBfxcwFtw8rDkqTE3AAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 76"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAxSURBVDhP7YrBCQAwEIO6/9IpGHCB+8ZXgr4S6PAW/ArBrxD8CsGvEPwKwa8Q/KlIPsh/Kw76i5dZAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 77"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAApSURBVDhPY0AG////h7JgbGQREBhVMaoCAkZVjKoYVQEDoyoGUMX//wBO0slFJYlhCgAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 78"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAzSURBVDhP7YoxCgAwDIT6/0+nYEC6d/W2U89unu0V4iuE+AohvkKIrxDiK4T4CiH+q5i57bwrDnNfueUAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 79"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAEFSURBVDhPNcnBAcBAEILA9N/05lCZH/o9J0LNjXlBqLkxLwg1N+YFoebGvCDU3JgXhJob84JQc2NeEGpuzAtCzY15Qai5MS8INTfmBaHmxrwg1NyYF4SaG/OCUHNjXhBqbswLQs2NeUGouTEvCDU35gWh5sa8INTcmBeEmhvzglBzY14Qam7MC0LNjXlBqLkxLwg1N+YFoebGvCDU3JgXhJob84JQc2NeEGpuzAtCzY15Qai5MS8INTfmBaHmxrwg1NyYF4SaG/OCUHNjXhBqbswLQs2NeUGouTEvCDU35gWh5sa8INTcmBeEmhvzglBzY14Qam7MC0LNjXlBqLkxLwg17+4HH336IvmzQQgAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			
			<xsl:when test="$code = 80"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACsSURBVDhPRcjBDcMADMPA7L+004JQjg/L5PPj7ro9H0rDh9LwoTR8KA0fSsOH0vChNHwoDR9Kw4fS8KE0fCgNH0rDh9LwoTR8KA0fSsOH0vChNHwoDR9Kw4fS8KE0fCgNH0rDh9LwoTR8KA0fSsOH0vChNHwoDR9Kw4fS8KE0fCgNH0rDh9LwoTR8KA0fSsOH0vChNHwoDR9Kw4fS8KE0fCgNH0rDh9Lw8fe7F8OE+iKL7HYOAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 81"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAySURBVDhP7YrBDQAgEIPcf+mqmGMBv+XVEtYh8Mb9g74F6FuAvgXoW4C+BehbgP6zSDaM1/oiztgPtwAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 82"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACcSURBVDhPTcnBCQAxAITA67/pTQgynC/F77LHX1AaBKVBUBoEpUFQGgSlQVAaBKVBUBoEpUFQGgSlQVAaBKVBUBoEpUFQGgSlQVAaBKVBUBoEpUFQGgSlQVAaBKVBUBoEpUFQGgSlQVAaBKVBUBoEpUFQGgSlQVAaBKVBUBoEpUFQGgSlQVAaBKVBUBoEpUFQGgSlQVAaBKVBsO0AshT6IiI8UfcAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 83"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAzSURBVDhP7YrBEQAgDIPcf+lYz5MM4Bc+UsMakpznMef9QSwsCgNiYVEYEAuLwoB8FskGC7D6Im/GHaoAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 84"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACqSURBVDhPRcjBEYAwAIRA+286Gm+Y5QU8H+fnWix9FkufxdJnsfRZLH0WS5/F0mex9FksfRZLn8XSZ7H0WSx9FkufxdJnsfRZLH0WS5/F0mex9FksfRZLn8XSZ7H0WSx9FkufxdJnsfRZLH0WS5/F0mex9FksfRZLn8XSZ7H0WSx9FkufxdJnsfRZLH0WS5/F0mex9FksfRZLn8XSZ7H0WSx9FkufxfLec14w7foiq87mBwAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 85"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACcSURBVDhPPcjJEQAgEMMw+m96OcbIr0TrNK+7fiT3RXJfJPdFcl8k90VyXyT3RXJfJPdFcl8k90VyXyT3RXJfJPdFcl8k90VyXyT3RXJfJPdFcl8k90VyXyT3RXJfJPdFcl8k90VyXyT3RXJfJPdFcl8k90VyXyT3RXJfJPdFcl8k90VyXyT3RXJfJPdFcl8k90VyXyT3RXJfZGY2+jH6ItE1OC4AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 86"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACQSURBVDhPXYlBCsAwAIP6/0+njIEWPSSC52XbvxFJQCQBkQREEhBJQCQBkQREEhBJQCQBkQREEhBJQCQBkQREEhBJQCQBkQREEhBJQCQBkQREEhBJQCQBkQREEhBJQCQBkQREEhBJQCQBkQREEhBJQCQBkQREEhBJQCQBkQREEhBJQCQBkQREEhBJQCThu+0Cr7f6InijmDYAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 87"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACpSURBVDhPTchBCoAAEMNA///pFQxMzSG0ef7cR+N/h8SNIXFjSNwYEjeGxI0hcWNI3BgSN4bEjSFxY0jcGBI3hsSNIXFjSNwYEjeGxI0hcWNI3BgSN4bEjSFxY0jcGBI3hsSNIXFjSNwYEjeGxI0hcWNI3BgSN4bEjSFxY0jcGBI3hsSNIXFjSNwYEjeGxI0hcWNI3BgSN4bEjSFxY0jcGBI3hsSNIfHdvXkK+iKhvETjAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 88"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAC1SURBVDhPXcnBCcAAEITA9N/0BSQuEl/CPO3oN4gVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVNogVvrl7AUJd+iLf6HiFAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 89"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAtSURBVDhPY4CA////ozEgAMEdVQECoypGVaCwRlWgskZVoLJGVaCyaKHi/38APWLJRfVZTRQAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			
			<xsl:when test="$code = 90"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAwSURBVDhP7coxCgAgEMRA///pCCpKattslTtm7AGn1u75/glFwpFwJBwJR8LxI2ACqrzJRYC4FxAAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 91"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAAsSURBVDhP7cohAgAwDIPA/f/TzERUpKYaFOLeDNgmKRR1kkJRJykUddJJwAcYJclF+SmbiQAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 92"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADKSURBVDhPPcnBDYAAEAJB+2/6FCQzj00Iz+fulG/+NpS+saH0jQ2lb2wofWND6RsbSt/YUPrGhtI3NpS+saH0jQ2lb2wofWND6RsbSt/YUPrGhtI3NpS+saH0jQ2lb2wofWND6RsbSt/YUPrGhtI3NpS+saH0jQ2lb2wofWND6RsbSt/YUPrGhtI3NpS+saH0jQ2lb2wofWND6RsbSt/YUPrGhtI3NpS+saH0jQ2lb2wofWND6RsbSt/YUPrGhtI3NpS+saH0vbt7AZ5H+iIlkkAIAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 93"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAEUSURBVDhPNcnBEcBADMLA9N+0c0KwDzPg77k7r5im1cgXTNNq5AumaTXyBdO0GvmCaVqNfME0rUa+YJpWI18wTauRL5im1cgXTNNq5AumaTXyBdO0GvmCaVqNfME0rUa+YJpWI18wTauRL5im1cgXTNNq5AumaTXyBdO0GvmCaVqNfME0rUa+YJpWI18wTauRL5im1cgXTNNq5AumaTXyBdO0GvmCaVqNfME0rUa+YJpWI18wTauRL5im1cgXTNNq5AumaTXyBdO0GvmCaVqNfME0rUa+YJpWI18wTauRL5im1cgXTNNq5AumaTXyBdO0GvmCaVqNfME0rUa+YJpWI18wTauRL5im1cgXTNNq5Aumubsf6MH6IurWr58AAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 94"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADnSURBVDhPRcnJEYAAEAJB8096dZAp+sXxfE5/ZlJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15sUmtebFJrXmxSa15s0t29e2f6IuVHFBMAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 95"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADrSURBVDhPRcnBDcAADMLA7r90WrBq7pEIeD53l/cjfherROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0TsGqtE7BqrROwaq0Tsenf3AkJd+iKfRTCHAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 96"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAEUSURBVDhPNcnBAcAwDMLA7r+0GyG4Dxh/z90R807ZOxGTL+ydiMkX9k7E5At7J2Lyhb0TMfnC3omYfGHvREy+sHciJl/YOxGTL+ydiMkX9k7E5At7J2Lyhb0TMfnC3omYfGHvREy+sHciJl/YOxGTL+ydiMkX9k7E5At7J2Lyhb0TMfnC3omYfGHvREy+sHciJl/YOxGTL+ydiMkX9k7E5At7J2Lyhb0TMfnC3omYfGHvREy+sHciJl/YOxGTL+ydiMkX9k7E5At7J2Lyhb0TMfnC3omYfGHvREy+sHciJl/YOxGTL+ydiMkX9k7E5At7J2Lyhb0TMfnC3omYfGHvREy+sHciJl/YOxGTL+ydiMkX9Lsf1PT6Ismta3gAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 97"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAADJSURBVDhPTclBCoAAEMNA///pFRsSnEOg9Pm7u3+xR+yKPWJX7BG7Yo/YFXvErtgjdsUesSv2iF2xR+yKPWJX7BG7Yo/YFXvErtgjdsUesSv2iF2xR+yKPWJX7BG7Yo/YFXvErtgjdsUesSv2iF2xR+yKPWJX7BG7Yo/YFXvErtgjdsUesSv2iF2xR+yKPWJX7BG7Yo/YFXvErtgjdsUesSv2iF2xR+yKPWJX7BG7Yo/YFXvErtgjdsUesSv2iF2xR+yKPWLXz90L5mT6It1UrTQAAAAASUVORK5CYII=" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 98"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAACXSURBVDhPTcjBCcAAEMOw7r/0lWJQqkcIfv7uro0yapRRo4waZdQoo0YZNcqoUUaNMmqUUaOMGmXUKKNGGTXKqFFGjTJqlFGjjBpl1CijRhk1yqhRRo0yapRRo4waZdQoo0YZNcqoUUaNMmqUUaOMGmXUKKNGGTXKqFFGjTJqlFGjjBpl1CijRhk1yqhRRo0yapRR8/27F3kK+iL1YAK1AAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 99"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAIAAADO52WxAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAArSURBVDhPYwCC////gygwQGYDAZQ7qgIKRlWMqhhVAQOjKkZVDAIV//8DAAa1yUXFCdpnAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<!-- trzy kody do zastosowania wyłącznie na potrzeby sumy kontrolnej -->
			<xsl:when test="$code = 100"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAYAAABBhfLmAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsIAAA7CARUoSoAAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA9SURBVEhL7coxCgAgDATBU1Lk/69NISiCxWKl/U2VHNuix6xRykjRve2/n/uJY3JMjskxOSbH5Jgc00csLTttClsiEU5TAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 101"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAYAAABBhfLmAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsIAAA7CARUoSoAAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA7SURBVEhL7cpBCgAhDEPRxPvfOY4i8pfOPg9KS/mWlG+2JLJ9N63fOPeTxtSYGlNjakyNqTE1ph+xNAFsAApiqVFIuQAAAABJRU5ErkJggg==" width="11" height="{$barcodeHeight}"/></xsl:when>
			<xsl:when test="$code = 102"><img border="0" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAzCAYAAABBhfLmAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsIAAA7CARUoSoAAAAAYdEVYdFNvZnR3YXJlAHBhaW50Lm5ldCA0LjAuNWWFMmUAAAA6SURBVEhL7cpBCgAgDAPB1P//OSpoyVHvO1DawpYkr2m2VVW9r/2Pcz8hTsSJOBEn4kSciBNx+oilCVQACmJAOOSrAAAAAElFTkSuQmCC" width="11" height="{$barcodeHeight}"/></xsl:when>
		</xsl:choose>
	</xsl:template>
	
	
	<!-- ++++++++++++++ obsługa dat ++++++++++++++++ -->
	
	<xsl:template name="translateMonthShortVariant">
		<xsl:param name="monthNo"/>
		
		<xsl:choose>
			<xsl:when test="$monthNo = 1">
				<xsl:text>01</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 2">
				<xsl:text>02</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 3">
				<xsl:text>03</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 4">
				<xsl:text>04</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 5">
				<xsl:text>05</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 6">
				<xsl:text>06</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 7">
				<xsl:text>07</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 8">
				<xsl:text>08</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 9">
				<xsl:text>09</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 10">
				<xsl:text>10</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 11">
				<xsl:text>11</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 12">
				<xsl:text>12</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>(miesiąc nieznany)</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="translateMonthVariant">
		<xsl:param name="monthNo"/>
		
		<xsl:choose>
			<xsl:when test="$monthNo = 1">
				<xsl:text>stycznia</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 2">
				<xsl:text>lutego</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 3">
				<xsl:text>marca</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 4">
				<xsl:text>kwietnia</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 5">
				<xsl:text>maja</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 6">
				<xsl:text>czerwca</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 7">
				<xsl:text>lipca</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 8">
				<xsl:text>sierpnia</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 9">
				<xsl:text>września</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 10">
				<xsl:text>października</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 11">
				<xsl:text>listopada</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 12">
				<xsl:text>grudnia</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>(miesiąc nieznany)</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="translateMonth">
		<xsl:param name="monthNo"/>
		
		<xsl:choose>
			<xsl:when test="$monthNo = 1">
				<xsl:text>styczeń</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 2">
				<xsl:text>luty</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 3">
				<xsl:text>marzec</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 4">
				<xsl:text>kwiecień</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 5">
				<xsl:text>maj</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 6">
				<xsl:text>czerwiec</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 7">
				<xsl:text>lipiec</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 8">
				<xsl:text>sierpień</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 9">
				<xsl:text>wrzesień</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 10">
				<xsl:text>październik</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 11">
				<xsl:text>listopad</xsl:text>
			</xsl:when>
			<xsl:when test="$monthNo = 12">
				<xsl:text>grudzień</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>(miesiąc nieznany)</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- formatowanie daty i czasu -->
	<xsl:template name="formatDateTimeShortVariant">
		<xsl:param name="date"/>
		
		<xsl:variable name="year" select="number(substring($date, 1, 4))"/>
		<xsl:variable name="monthIndex" select="number(substring($date, 5, 2))"/>
		<xsl:variable name="day" select="number(substring($date, 7, 2))"/>
		
		<xsl:choose>
			<xsl:when test="$day">
				<xsl:value-of select="$day"/>
				<xsl:text>.</xsl:text>
				<xsl:call-template name="translateMonthShortVariant">
					<xsl:with-param name="monthNo" select="$monthIndex"/>
				</xsl:call-template>
				<xsl:text>.</xsl:text>
				<xsl:value-of select="$year"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$monthIndex">
					<xsl:call-template name="translateMonth">
						<xsl:with-param name="monthNo" select="$monthIndex"/>
					</xsl:call-template>
					<xsl:text> </xsl:text>
				</xsl:if>
				<xsl:value-of select="$year"/>
				<!-- <xsl:text> r.</xsl:text> -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- data i czas jako @value lub hl7:high/@value i hl7:low/@value -->
	<!-- obsługa ograniczona do danych przeznaczonych do wizualizacji, brak wyświetlania szeregu atrybutów TS i IVL TS -->
	<xsl:template name="dateTimeInDiv">
		<xsl:param name="date"/>
		<xsl:param name="label"/>
		<xsl:param name="prefix" select="false()"/>
		
		<xsl:if test="$date">
			<xsl:if test="$label">
				<div class="row_label cell">
					<xsl:value-of select="$label"/>
				</div>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="$date/@nullFlavor">
					<xsl:call-template name="translateNullFlavor">
						<xsl:with-param name="nullableElement" select="$date"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$date/@value">
					<div class="row_value cell">
						<xsl:if test="$prefix and string-length($prefix) &gt;= 1">
							<xsl:value-of select="$prefix"/>
							<xsl:text> </xsl:text>
						</xsl:if>
						<xsl:call-template name="formatDateTime">
							<xsl:with-param name="date" select="$date/@value"/>
						</xsl:call-template>
					</div>
				</xsl:when>
				<xsl:when test="$date/hl7:low/@value and $date/hl7:high/@value">
					<div class="row_value cell">
						<xsl:call-template name="formatDateTime">
							<xsl:with-param name="date" select="$date/hl7:low/@value"/>
						</xsl:call-template>
						<xsl:text> - </xsl:text>
						<xsl:call-template name="formatDateTime">
							<xsl:with-param name="date" select="$date/hl7:high/@value"/>
						</xsl:call-template>
					</div>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text> (nie podano)</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<!-- formatowanie daty i czasu -->
	<xsl:template name="formatDateTime">
		<xsl:param name="date"/>
		<xsl:param name="shift" select="false()"/>
		<xsl:param name="side" select="false()"/>
		
		<xsl:variable name="year" select="number(substring($date, 1, 4))"/>
		<xsl:variable name="monthIndex" select="number(substring($date, 5, 2))"/>
		<xsl:variable name="day" select="number(substring($date, 7, 2))"/>
		<xsl:variable name="hour" select="substring($date, 9, 2)"/>
		<xsl:variable name="minute" select="substring($date, 11, 2)"/>
		<xsl:variable name="second" select="substring($date, 13, 2)"/>
		
		<xsl:choose>
			<xsl:when test="$day">
				<xsl:value-of select="$day"/>
				<xsl:text> </xsl:text>
				<xsl:call-template name="translateMonthVariant">
					<xsl:with-param name="monthNo" select="$monthIndex"/>
				</xsl:call-template>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$year"/>
				<!-- <xsl:text> r.</xsl:text> -->
				
				<xsl:if test="$hour">
					<xsl:text> </xsl:text>
					<xsl:choose>
						<xsl:when test="$minute">
							<xsl:text> godz. </xsl:text>
							<xsl:choose>
								<xsl:when test="$hour = 00">
									<xsl:value-of select="$hour"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="number($hour)"/>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:text>:</xsl:text>
							<xsl:value-of select="$minute"/>
							<xsl:if test="$second">
								<xsl:text>:</xsl:text>
								<xsl:value-of select="$second"/>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text> godz. ok. </xsl:text>
							<xsl:value-of select="$hour"/>
							<xsl:text>.</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="$monthIndex">
					<xsl:call-template name="translateMonth">
						<xsl:with-param name="monthNo" select="$monthIndex"/>
					</xsl:call-template>
					<xsl:text> </xsl:text>
				</xsl:if>
				<xsl:value-of select="$year"/>
				<!-- <xsl:text> r.</xsl:text> -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- porównanie dat przez porównanie liczby typu 20150314 -->
	<xsl:template name="isFirstDateLaterThanSecond">
		<xsl:param name="firstDate"/>
		<xsl:param name="secondDate"/>
		
		<xsl:variable name="first" select="number(substring($firstDate, 1, 8))"/>
		<xsl:variable name="second" select="number(substring($secondDate, 1, 8))"/>

		<xsl:value-of select="$first &gt; $second"/>
	</xsl:template>
	
	<!-- znane węzły OID -->
	<xsl:template name="translateOID">
		<xsl:param name="oid"/>
		<xsl:param name="functionCode"/>		
		<xsl:choose>
			<!--<xsl:when test="$oid='2.16.840.1.113883.3.4424.1.1.616'">
			<xsl:text>PESEL</xsl:text>
			</xsl:when>-->
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.1.6.1'">
				<xsl:text>PWZ farmaceuty</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.1.6.2'">
				<xsl:text>PWZ lekarza</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.1.6.3' and $functionCode='PIEL'">
				<xsl:text>PWZ pielęgniarki</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.1.6.3' and $functionCode='POL'">
				<xsl:text>PWZ położnej</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.1.6.4'">
				<xsl:text>PWZ diagnosty lab.</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.2.2.1'">
				<xsl:text>REGON</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.2.2.2'">
				<xsl:text>REGON</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.2.1'">
				<xsl:text>NIP</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.2.3.1'">
				<xsl:text>I cz. kodu resort.</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.2.3.2'">
				<xsl:text>I-V cz. kodu resort.</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.2.3.3'">
				<xsl:text>I-VII cz. kodu resort.</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.2.6'">
				<xsl:text>Apteka</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.3.1'">
				<xsl:text>Oddział NFZ</xsl:text>
			</xsl:when>
			<xsl:when test="$oid='2.16.840.1.113883.3.4424.11.1.49'">
				<xsl:text>Kod kraju</xsl:text>
			</xsl:when>
			<xsl:when test="starts-with($oid, '2.16.840.1.113883.3.4424.2.4.')">
				<xsl:text>Praktyka lekarska</xsl:text>
			</xsl:when>
			<xsl:when test="starts-with($oid, '2.16.840.1.113883.3.4424.2.5.')">
				<xsl:text>Praktyka pielęgniarska</xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!-- nullFlavor-->
	<xsl:template name="translateNullFlavor">
		<xsl:param name="nullableElement"/>
		<!-- HL7 CDA dopuszcza podanie nullFlavor dla każdego kwantu dancyh i każdego elementu
			 obsłużono wyłącznie najważniejsze przypadki i najpopularniejsze kody:
			 NI = No Information. This is the most general and default null flavor.
			 NA = Not Applicable. Known to have no proper value (e.g., last menstrual period for a male).
			 UNK = Unknown. A proper value is applicable, but is not known.
			 ASKU = asked, but not known. Information was sought, but not found (e.g., the patient was asked but did not know).
			 NAV = temporarily unavailable. The information is not available, but is expected to be available later.
			 NASK = Not Asked. The patient was not asked. -->
		<xsl:if test="not($nullableElement) or $nullableElement/@nullFlavor">
			<span class="null_flavor">
				<xsl:choose>
					<xsl:when test="not($nullableElement)">
						<xsl:text>(nie podano)</xsl:text>
					</xsl:when>
					<xsl:when test="$nullableElement/@nullFlavor='NI'">
						<xsl:text>(brak informacji)</xsl:text>
					</xsl:when>
					<xsl:when test="$nullableElement/@nullFlavor='NA'">
						<xsl:text>(nie dotyczy)</xsl:text>
					</xsl:when>
					<xsl:when test="$nullableElement/@nullFlavor='UNK'">
						<xsl:text>(nieznane)</xsl:text>
					</xsl:when>
					<xsl:when test="$nullableElement/@nullFlavor='ASKU'">
						<xsl:text>(nie uzyskano informacji)</xsl:text>
					</xsl:when>
					<xsl:when test="$nullableElement/@nullFlavor='NAV'">
						<xsl:text>(czasowo niedostępne)</xsl:text>
					</xsl:when>
					<xsl:when test="$nullableElement/@nullFlavor='NASK'">
						<xsl:text>(nie pytano)</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>(nie podano)</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</span>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="styles">
		<style type="text/css">
			<xsl:text>

@media screen {
	body {
		margin: 0px;
		display: block;
		background-color: #f1f1f1;
	}

    .noPrint{}

    .noScreen{display:none;}

	.page_break_avoid {display:none;}

	.document {
		margin: 15px auto;
		width: 300px;
		overflow: hidden;
		font-family: "Noto sans", sans-serif;
		font-size: 9pt;
		-webkit-box-shadow: 0px 0px 2px 2px #dcdcdc;
		box-shadow: 0px 0px 2px 2px #dcdcdc;
		background-color: white;
	}
	
	.patient_statement {
		display:none;
	}
	.oswiadczenie
	{
		margin:10px;
		text-align: center;
		font-family: "Noto sans", sans-serif;
		font-size: 7pt;
		border: 0.1em black solid;
	}							
}

@media print {
	body {
		margin: 0px;
		display: block;
		background-color: white;
	}

	.document {
		width: 80mm;
		overflow: hidden;
		font-family: "Noto sans", sans-serif;
		font-size: 9pt;
		background-color: white;
		background-repeat: no-repeat;
		background-image: none;
	}
	
	/* tymczasowe wyłączenie
	.page_break_avoid {
		page-break-after: avoid;
	}*/
	.page_break_avoid {display:none;}
	
	.patient_statement {
		margin:10px;
		text-align: center;
		font-family: "Noto sans", sans-serif;
		font-size: 7pt;
		padding: 5px;
		border: 0.1em black solid;
	}

	.patient_signature {
		padding: 20px 0 0 0;
	}
	
	.patient_signature_label {
		font-size: 5pt;
		font-family: "Noto sans", sans-serif;
	}
	.oswiadczenie
	{
		margin:10px;
		text-align: center;
		font-family: "Noto sans", sans-serif;
		font-size: 7pt;
		border: 0.1em black solid;
		page-break-before: always;
	}
}

.title {
	height: 44px;
	margin-top: 2px;
}

.title_img {
	max-width: 45%;
}

.title_suffix {
	font-size: 0.7em;
	font-weight: bold;
	position: absolute;
	top: 35px;
}

.doc_header {
	width: 100%;
}

.doc_body {
	width: 100%;
	border-top: 1px black solid;
}

.doc_title {
	font-size: 1.2em;
	text-align: center;
	font-weight: bold;
	border-bottom: 3px black solid;
	margin-top: 3px;
}

.section_title {
	font-weight: bold;
	padding: 3px 0 0 0;
}

.section_title_left {
	float: left;
	font-size: 8pt;
	font-weight: bold;
	padding: 3px 11px 0 11px;
}
.section_title_right {
	float: right;
    font-size: 7pt;
	padding: 3px 11px 0 11px;
}

.section_text_1 {
	padding: 5px 11px;
	font-size: 10pt;
}

.klucz_id {
	width: 277px;
	padding: 0 11px 0 12px;
}

.klucz {
	text-align: right;
}
.klucz_value {
	font-size: 8pt;
}

.doc_id {
	font-size: 7pt;
	text-align: right;
	padding-top: 1px;
}
.doc_id_label {
	float: left;
	vertical-align:top;
}
.doc_id_value {
	float: right;
	vertical-align: bottom;
	font-size: 7pt;
}

	.kod_time {
		padding: 4px 0 3px 0;
	}
	
	.kod {
	}
	
	.kod_label {
		margin-left: 11px;
	}
	
	.kod_value {
		padding-left: 5px; 
	}
	
	.effective_time {
		text-align: right;
	}
	
	.effective_time_label {
		margin-right: 11px;
	}
	
	.effective_time_value {
		font-weight: normal;
		padding-left: 3px;
	}

	.border_top {
		border-top: 1px black solid;
	}

.disclaimer {
	font-size: 0.9em;
	text-align: center;
	padding: 0 7px;
}

.strona_ikp {
	text-align: center;
	font-size: 6pt;
	padding-top: 5px;
	padding-bottom:5px;
}

.header_label {
	font-weight: bold;
	padding: 3px 0 0 7px;
}

.header_value {
	padding: 3px 7px 0 7px;
}

.header_element {
	/*oznaczenie elementu nagłówka dokumentu*/
}

.bold {
	font-weight: bold;
}

.header_inline_value {
	display: inline;
}

.body_element {
	width: 100%;
}

.section_block {
	display: table;
	width: 100%;
}
.section_text_block {
	display: table-cell;
	width: 100%;
}
.payment_block {
	display: table-cell;
}

.payment_text {
	font-size: 9pt;
	padding-left: 3px;
	top: 50%;
	border-left: 1px solid black;
	white-space:nowrap;
	width: 30px;
}

.table {
	display: table;
}
.table > div:nth-last-child(1) > div {
	padding-bottom: 3px;
}
.row {
	display: table-row;
}
.cell {
	display: table-cell;
}

.row_value {
	padding-top: 3px;
	padding-right: 11px;
	overflow-wrap: break-word;
	word-wrap: break-word;
	-ms-word-break: break-all;
	word-break: break-word;
}

.row_value_bold {
	padding-top: 3px;
	padding-right: 7px;
	overflow-wrap: break-word;
	word-wrap: break-word;
	-ms-word-break: break-all;
	word-break: break-word;
	font-weight: bold;
	hyphens: auto;
}

.small {
	font-size: 8pt;
}

.emphasized {
	font-weight: bold;
	font-size: 11pt !important;
}

.emphasized_id_label {
	font-size: 8pt !important;
}

.row_value > div:first-child {
	padding-top: 0;
}

.row_value_element {
	padding-top: 1px;
}

.row_value_element_patient {
	padding-top: 3px;
	font-size: 11pt;
	font-weight: bold;
}

.row_label {
	width: 90px;
	font-weight: bold;
	font-size: 8pt;
	padding-top: 3px;
	padding-left: 11px;
}

.row_label_inline {
	font-weight: bold;
	font-size: 8pt;
}

.row_value_inline {
	font-size: 8pt;
}

.not_known_id_prefix {
	font-weight: bold;
}

.address_value {
	padding-left: 7px;
}

.caption {
	font-weight: bold;
}
.paragraph:not(:last-child) {
	margin-bottom: 5px;
}
.paragraph_caption {
	padding-right: 3px;
}
.paragraph_text {
}

.footnote_div {
	border-top: 1px solid #dcdcdc;
	padding: 7px;
}
.footnote_label {
	font-size: 1.0em;
	font-weight: bold;
}
.footnote_values {
	font-size: 0.9em;
}
.footnote_value {
	margin: 2px 0 0 15px;
}

ol, ul {
	margin: 0;
}

.table_caption {
	font-weight: bold;
}
table {
	border-collapse: collapse;
}
th, td {
	padding: 5px;
}

#footer {
    position: running(footer);
    text-align: right;
    padding-right: 2px;
}

@page {
    size: 105mm 297mm;
    margin: 5mm;

    @bottom-right {
        content: element(footer);
    }
}

#pagenumber:before {
    content: counter(page);
}

#pagecount:before {
    content: counter(pages);
}
	.wykup-leku-info {
	text-align: justify;
	border: 0.1em black solid;
	padding: 5px;
}								
			</xsl:text>
			
			<!-- jeśli nie użyto żadnych stylów typu Rrule Lrule Toprule Botrule,
				 dodawany jest styl delikatnej szarej linii -->
			<xsl:if test="//hl7:table and not(//*[contains(@styleCode, 'Botrule')] or //*[contains(@styleCode, 'Lrule')] or //*[contains(@styleCode, 'Rrule')] or //*[contains(@styleCode, 'Toprule')])">
				<xsl:text>
table, th, td {
	border: 1px solid #dcdcdc;
}
				</xsl:text>
			</xsl:if>
		</style>
	</xsl:template>
	
	<!-- ++++++++++++++++++++++++++++++++++++++ OBSŁUGA NARRATIVE BLOCK (kod polskiej transformaty HL7 CDA, brak obsługi multimediów) +++++++++++++++++++++++++++++++++++++++++++-->
	<xsl:template name="sectionText">
		<xsl:param name="text"/>
		<xsl:apply-templates select="$text"/>
	</xsl:template>

	<xsl:template name="sectionTitle">
		<xsl:param name="tytulRecepty"/>
		<xsl:apply-templates select="$tytulRecepty"/>
	</xsl:template>
	
	<!-- Transformata przekodowuje tagi MIME type "text/x-hl7-text+xml" na html:
        <content> - odpowiednik <span> w HTML, posiada opcjonalny identyfikator wykorzystywany do wskazywania tego tekstu w bloku entry.
        <sub> oraz <sup> - identyczne jak w HTML
        <br> - identyczne jak w HTML
        <footnote> oraz <footnoteRef> - bez odpowiedników w HTML, należy oprogramować
        <caption> - nagłówek elementów paragraph, list, list item, table, table cell, renderMultimedia. Może zawierać linki, przypisy, sub, sup.
        <paragraph> - odpowiednik <p> w HTML
        <linkHtml> - odpowiednik <a> w HTML, nie identyczny
        <list> z atrybutem @listType oraz elementem <item> - odpowiednik list <ol> i <ul> z elementem <li> w HTML
        <table> z elementami <thead>, <tbody>, <tfoot>, <th>, <td>, <tr>, <colgroup>, <col>, <caption> - identyczne jak w HTML
        atrybut styleCode z listą prymitywnych wartości.
        -->

	<!-- content -->
	<xsl:template match="hl7:content">
		<xsl:choose>
			<xsl:when test="@revised='delete'">
				<!-- content wyróżniający fragmenty tekstu jako usunięte z poprzedniej wersji dokumentu -->
				<!-- tekst nie jest wyświetlany, pomijana jest cała usunięta zawartość, 
					 można rozważyć czy dodać specjalną obsługę revised (insert/delete), aktualnie uznano, że są to informacje nadmiarowe -->
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="span">
					<xsl:apply-templates select="@styleCode"/>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- sup -->
	<xsl:template match="hl7:sup">
		<xsl:element name="sup">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	
	<!-- sub -->
	<xsl:template match="hl7:sub">
		<xsl:element name="sub">
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	
	<!-- br -->
	<xsl:template match="hl7:br">
		<xsl:element name='br'>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	
	<!-- przypis w sekcji -->
	<xsl:template match="hl7:footnote">
		<xsl:variable name="referenceId" select="@ID"/>
		<sup>
			<xsl:text>[</xsl:text>
			<xsl:choose>
				<xsl:when test="$referenceId">
					<a href="#przypis-{$referenceId}">
						<xsl:value-of select="$referenceId"/>
					</a>
				</xsl:when>
				<xsl:otherwise>
					<!-- pojedyncze wystąpienie bez ID, brak odnośnika -->
					<span class="footnote_text_inline">
						<xsl:apply-templates/>
					</span>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>]</xsl:text>
		</sup>
	</xsl:template>
	
	<!-- odnośnik do przypisu -->
	<xsl:template match="hl7:footnoteRef">
		<xsl:variable name="referencedId" select="@IDREF"/>
		<sup>
			<xsl:text>[</xsl:text>
			<a href="#przypis-{$referencedId}">
				<xsl:value-of select="$referencedId"/>
			</a>
			<xsl:text>]</xsl:text>
		</sup>
	</xsl:template>
	
	<!-- przypis - wyświetlenie -->
	<xsl:template name="footnotesOnTheBottom">
		<xsl:variable name="footnotes" select=".//hl7:footnote[@ID]"/>
		
		<xsl:if test="$footnotes">
			<div class="footnote_div">
				<span class="footnote_label">
					<xsl:text>Przypisy</xsl:text>
				</span>
				<div class="footnote_values">
					<xsl:for-each select="$footnotes">
						<xsl:if test="./@ID">
							<div class="footnote_value">
								<a id="przypis-{./@ID}">
									<xsl:value-of select="./@ID"/>
									<xsl:text>. </xsl:text>
									<xsl:apply-templates/>
								</a>
							</div>
						</xsl:if>
					</xsl:for-each>
				</div>
			</div>
		</xsl:if>
	</xsl:template>
	
	<!-- nagłówek w przypadkach innych niż dla elementu paragraph i table -->
	<xsl:template match="hl7:caption">
		<xsl:element name="span">
			<xsl:attribute name="class">list_caption caption</xsl:attribute>
			<xsl:apply-templates select="@styleCode"/>
			<xsl:apply-templates/>
		</xsl:element>
		<xsl:text> </xsl:text>
	</xsl:template>
	
	<!-- nagłówek akapitu
		parametr intentionally wyokrzystywany jest do wyjęcia <caption> z elementu <paragraph> 
		w sytuacji gdy caption nie jest pierwszym węzłem paragraph,
		umieszczenie tekstu w <paragraph> przed elementem <caption> jest zgodne z XSD 
		o ile tekst nie zawiera innych elementów, nie jest jednak zalecane -->
	<xsl:template match="hl7:paragraph/hl7:caption">
		<xsl:param name="intentionally" select="false()"/>
		<xsl:if test="$intentionally">
			<xsl:element name="span">
				<xsl:attribute name="class">paragraph_caption caption</xsl:attribute>
				<xsl:apply-templates select="@styleCode"/>
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	
	<!-- paragraph -->
	<xsl:template match="hl7:paragraph">
		<div class="paragraph">
			<xsl:element name="div">
				<xsl:attribute name="class">paragraph_text</xsl:attribute>
				<xsl:apply-templates select="@styleCode"/>
				<xsl:apply-templates select="hl7:caption">
					<xsl:with-param name="intentionally" select="true()"/>
				</xsl:apply-templates>
				<!-- spowoduje wywołanie template'ów dla wszystkich węzłów i dla caption, 
					jednak template caption nie wykona się bez parametru "intentionally" -->
				<xsl:apply-templates/>
			</xsl:element>
		</div>
	</xsl:template>
	
	<!-- list -->
	<xsl:template match="hl7:list">
		
		<xsl:apply-templates select="hl7:caption">
			<xsl:with-param name="intentionally" select="true()"/>
		</xsl:apply-templates>
		
		<xsl:choose>
			<xsl:when test="@listType='ordered'">
				<xsl:element name="ol">
					<xsl:choose>
						<!-- HTML5 nie wspiera tych typów -->
						<xsl:when test="contains(@styleCode, 'Arabic')">
							<xsl:attribute name="type">1</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(@styleCode, 'BigAlpha')">
							<xsl:attribute name="type">A</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(@styleCode, 'BigRoman')">
							<xsl:attribute name="type">I</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(@styleCode, 'LittleAlpha')">
							<xsl:attribute name="type">a</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(@styleCode, 'LittleRoman')">
							<xsl:attribute name="type">i</xsl:attribute>
						</xsl:when>
					</xsl:choose>
					<xsl:apply-templates select="@styleCode"/>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="ul">
					<xsl:choose>
						<!-- HTML5 nie wspiera tych typów -->
						<xsl:when test="contains(@styleCode, 'Circle')">
							<xsl:attribute name="type">circle</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(@styleCode, 'Disc')">
							<xsl:attribute name="type">disc</xsl:attribute>
						</xsl:when>
						<xsl:when test="contains(@styleCode, 'Square')">
							<xsl:attribute name="type">square</xsl:attribute>
						</xsl:when>
					</xsl:choose>
					<xsl:apply-templates select="@styleCode"/>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- nagłówek listy przed głównym elementem listy
		 kolejny zabieg z intentionally pozwala uniknąć operatora exerpt z XPATH 2.0 -->
	<xsl:template match="hl7:list/hl7:caption">
		<xsl:param name="intentionally" select="false()"/>
		
		<xsl:if test="$intentionally">
			<xsl:element name="span">
				<xsl:attribute name="class">list_caption caption</xsl:attribute>
				<xsl:apply-templates select="@styleCode"/>
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="hl7:list/hl7:item">
		<xsl:element name="li">
			<xsl:apply-templates select="@styleCode"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	
	<!-- nagłówek elementu listy -->
	<xsl:template match="hl7:list/hl7:item/hl7:caption">
		<xsl:element name="span">
			<xsl:attribute name="class">list_caption caption</xsl:attribute>
			<xsl:apply-templates select="@styleCode"/>
			<xsl:apply-templates/>
		</xsl:element>
		<xsl:text> </xsl:text>
	</xsl:template>
	
	<!-- zmiana nazwy bez przepisywania ze względów bezpieczeństwa, wyłącznie dla znanych wartości, 
		w tym poza stylami HL7 CDA dodano dopuszczalne przez ten standard polskie rozszerzenia dot. kolorów czcionek
		(zastosowano style, gdyż jest silniejsze niż przypisany class) -->
	<xsl:template match="@styleCode">
		<xsl:if test="string-length(.) &gt;= 1">
			<xsl:attribute name="style">
				<xsl:if test="contains(., 'Italics')"> font-style: italic;</xsl:if>
				<xsl:if test="contains(., 'Bold')"> font-weight: bold;</xsl:if>
				<xsl:if test="contains(., 'Underline')"> text-decoration: underline;</xsl:if>
				<xsl:if test="contains(., 'Emphasis')"> font-style: bold;</xsl:if>
				<xsl:if test="contains(., 'xPLred')"> color: red;</xsl:if>
				<xsl:if test="contains(., 'xPLgreen')"> color: green;</xsl:if>
				<xsl:if test="contains(., 'xPLblue')"> color: blue;</xsl:if>
				<xsl:if test="contains(., 'xPLlime')"> color: lime;</xsl:if>
				<xsl:if test="contains(., 'xPLolive')"> color: olive;</xsl:if>
				<xsl:if test="contains(., 'xPLorange')"> color: orange;</xsl:if>
				<xsl:if test="contains(., 'xPLnavy')"> color: navy;</xsl:if>
				<xsl:if test="contains(., 'xPLviolet')"> color: violet;</xsl:if>
				<xsl:if test="contains(., 'xPLpurple')"> color: purple;</xsl:if>
				<xsl:if test="contains(., 'xPLsilver')"> color: silver;</xsl:if>
				<xsl:if test="contains(., 'xPLgray')"> color: gray;</xsl:if>
				<xsl:if test="contains(., 'xPLbig')"> font-size: 11pt;</xsl:if>
				<xsl:if test="contains(., 'xPLsmall')"> font-size: 9pt;</xsl:if>
				<xsl:if test="contains(., 'xPLxsmall')"> font-size: 8pt;</xsl:if>
			</xsl:attribute>
		</xsl:if>
	</xsl:template>
	
	<!--  Tabele  -->
	<!-- Znaki dopuszczalne w atrybutach, obsługa w XPATH 1.0, tj. bez wyrażeń regularnych -->
	<xsl:variable name="CHARACTERS_ALLOWED_IN_TABLE_ATTRIBUTES">abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890 ,.-_!</xsl:variable>
	
	<!-- tabele są identyczne jak w HTML (poza atrybutem styleCode), są więc kopiowane bez zmian
		 XSD dopuszcza wiele atrybutów nieobsługiwanych w HTML5, ale dopuszczalnych tutaj. -->
	<xsl:template match="hl7:table | hl7:col | hl7:colgroup | hl7:tbody | hl7:td | hl7:tfoot | hl7:th | hl7:thead | hl7:tr">
		<xsl:element name="{local-name()}">

			<xsl:call-template name="copyTableAttributes">
				<xsl:with-param name="tagName" select="local-name()"/>
				<xsl:with-param name="attributes" select="./@*"/>
			</xsl:call-template>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>

	<!-- atrybuty pochodzące z HTML dopuszczalne w XSD Narrative Block dla elementów tabeli
		 wszystkie wartości tych atrybutów będą przepisywane bez zmian niniejszą transformatą z postaci "text/x-hl7-text+xml" do "text/html" -->
	<xsl:variable name="TABLE_ALLOWED_ATTRIBUTES">
		<item name="COL">;ID;language;span;width;align;char;charoff;valign;</item>
		<item name="COLGROUP">;ID;language;span;width;align;char;charoff;valign;</item>
		<item name="TABLE">;ID;language;summary;width;border;frame;rules;cellspacing;cellpadding;</item>
		<item name="TBODY">;ID;language;align;char;charoff;valign;</item>
		<item name="TD">;ID;language;abbr;axis;headers;scope;rowspan;colspan;align;char;charoff;valign;</item>
		<item name="TFOOT">;ID;language;align;char;charoff;valign;</item>
		<item name="TH">;ID;language;abbr;axis;headers;scope;rowspan;colspan;align;char;charoff;valign;</item>
		<item name="THEAD">;ID;language;align;char;charoff;valign;</item>
		<item name="TR">;ID;language;align;char;charoff;valign;</item>
	</xsl:variable>
	
	<!-- pełna kontrola nad tym co jest kopiowane -->
	<xsl:template name="copyTableAttributes">
		<xsl:param name="tagName"/>
		<xsl:param name="attributes"/>
		
		<xsl:param name="allowedAttributes" select="document('')/*/xsl:variable[@name='TABLE_ALLOWED_ATTRIBUTES']/*"/>
		<!--<xsl:param name="allowedAttributes" select="$TABLE_ALLOWED_ATTRIBUTES/*"/>-->
		
		<xsl:for-each select="$attributes">
			<xsl:if test="string-length(translate(., $CHARACTERS_ALLOWED_IN_TABLE_ATTRIBUTES, '')) = 0">
				<xsl:choose>
					<xsl:when test="local-name(.) = 'styleCode'">
						<xsl:if test="string-length(.) &gt;= 1">
							<xsl:attribute name="style">
								<xsl:if test="contains(., 'Italics')"> font-style: italic;</xsl:if>
								<xsl:if test="contains(., 'Bold')"> font-weight: bold;</xsl:if>
								<xsl:if test="contains(., 'Underline')"> text-decoration: underline;</xsl:if>
								<xsl:if test="contains(., 'Emphasis')"> font-style: bold;</xsl:if>
								<xsl:if test="contains(., 'Botrule')"> border-bottom: 1pt solid #dcdcdc;</xsl:if>
								<xsl:if test="contains(., 'Lrule')"> border-left: 1pt solid #dcdcdc;</xsl:if>
								<xsl:if test="contains(., 'Rrule')"> border-right: 1pt solid #dcdcdc;</xsl:if>
								<xsl:if test="contains(., 'Toprule')"> border-top: 1pt solid #dcdcdc;</xsl:if>
							</xsl:attribute>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="contains($allowedAttributes[@name=translate($tagName, $LOWERCASE_LETTERS, $UPPERCASE_LETTERS)], concat(';',local-name(.),';'))">
							<xsl:copy-of select="."/>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<!-- nagłówek tabeli to standardowo i wyjątkowo element html caption -->
	<xsl:template match="hl7:table/hl7:caption">
		<xsl:element name="caption">
			<xsl:attribute name="class">table_caption caption</xsl:attribute>
			<xsl:apply-templates select="@styleCode"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	
	
	<!-- odnośnik -->
	<xsl:template match="hl7:linkHtml">
		<xsl:element name="a">
			<xsl:attribute name="href"><xsl:value-of select="./@href"/></xsl:attribute>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>