<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:sig="http://www.w3.org/2000/09/xmldsig#">
	<xsl:variable name="wersja-common" select="'1.1.0'"/>
	<xsl:output encoding="UTF-8" indent="yes" 
	doctype-public="-//W3C//DTD HTML 4.01//EN" 
	media-type="text/html"/>
	<xsl:template name="bladTypDokumentu">
		<div class="blad">
			BŁĄD: NIEPOPRAWNY TYP DOKUMENTU, DOKUMENT NIE JEST W WERSJI ELEKTRONICZNEJ
		</div>
	</xsl:template>
	<xsl:template name="bladTypDokumentuNieelektr">
		<div class="blad">
			BŁĄD: NIEPOPRAWNY TYP DOKUMENTU, DOKUMENT JEST W WERSJI ELEKTRONICZNEJ
		</div>
	</xsl:template>	
	<xsl:template name="bladNamespace">
		<div class="blad">
			BŁĄD: NIEPOPRAWNY NAMESPACE DOKUMENTU DLA WYBRANEJ TRANSFORMATY
		</div>
	</xsl:template>

	<xsl:template name="bladNrDruku">
		<div class="blad">
			BŁĄD: NIEPOPRAWNY NR DRUKU DOKUMENTU DLA TEJ WERSJI TRANSFORMATY
		</div>
	</xsl:template>
	<xsl:template name="checkNamespace">
		<xsl:param name="namespaces" />
		<xsl:choose>
			<xsl:when test="namespace::*[not($namespaces)]">			
				<html>
					<head>
						<meta http-env="ContentType"></meta>
						<xsl:call-template name="StyleWspolne" />
					</head>
					<body>
						<xsl:call-template name="bladNamespace">
						</xsl:call-template>
						<footer>
							<xsl:call-template name="footer">
								<xsl:with-param name="wersja" select="$wersja" />
							</xsl:call-template>
						</footer>
					</body>
				</html>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
		
	<xsl:template name="header">
		<xsl:param name="zlecenie" />		
			<div class="sekcja">
				<xsl:call-template name="headerTable">
					<xsl:with-param name="zlecenie" select="$zlecenie"/>
				</xsl:call-template>
			</div>
	</xsl:template>

	<xsl:template name="headerTable">
		<xsl:param name="zlecenie" />		
				<table class="rubryka" style="height: 90px;">
					<xsl:variable name="nr-zlecenia-nfz" select="$zlecenie/@nr-zlecenia-nfz" />
					<tr>
						<th class="opis-pola" style="width: 45%;">							
							Identyfikator zlecenia					
						</th>
						<th class="opis-pola" style="width: 45%;">
							Kod kreskowy
						</th>
					</tr>
					<tr>
						<td class="pole">
							<xsl:value-of select="$nr-zlecenia-nfz" />
						</td>
						<td class="pole">
							<p></p>
						</td>
					</tr>
				</table>
	</xsl:template>
	
	<xsl:template name="footer">
		<xsl:param name="wersja" />
			<p style="font-size: 12px; margin-bottom: 0px;" align="right">
<!-- 				<xsl:text>Data wygenerowania: </xsl:text> -->
<!-- 				<xsl:call-template name="dateTimeFormatYYYY-MM-DD"> -->
<!-- 					<xsl:with-param name="data" select=""/> -->
<!-- 				</xsl:call-template> -->
				<xsl:text>Wersja transformaty: </xsl:text>
				<xsl:value-of select="$wersja" />
			</p>
	</xsl:template>

	<xsl:template name="signature">
		<xsl:param name="dokument-zpo" />
		<xsl:param name="signature-value" />
		<xsl:param name="signature-time" />
		<xsl:if test="$signature-value">
			<p style="font-size: 14px;">
				<strong>
					<xsl:text>Podpisano elektronicznie</xsl:text>
				</strong>
			</p>
			<p style="font-size: 12px;">
				<xsl:if test="$signature-time">
					<xsl:text>Data złożenia podpisu: </xsl:text>
					<xsl:call-template name="dateTimeFormat">
						<xsl:with-param name="data"
							select="$signature-time" />
					</xsl:call-template>
				</xsl:if>
			</p>
		</xsl:if>
		<xsl:if test="not($signature-value)">
			<xsl:call-template name="signatureSigNs">
				<xsl:with-param name="dokument-zpo"
					select="$dokument-zpo" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="signatureSigNs">
		<xsl:param name="dokument-zpo" />
		<xsl:variable name="signature" select="$dokument-zpo/sig:Signature" />
		<xsl:if test="$signature">
			<xsl:if test="$signature/sig:SignatureValue">
				<p style="font-size: 14px;">
					<strong>
						<xsl:text>Podpisano elektronicznie</xsl:text>
					</strong>
				</p>
				<p style="font-size: 12px;">
					<xsl:variable name="sign-date" select="$signature/sig:Object/sig:QualifyingProperties/sig:SignedProperties/sig:SignedSignatureProperties/sig:SigningTime" />
					<xsl:if test="$sign-date">
						<xsl:text>Data złożenia podpisu: </xsl:text>
						<xsl:call-template name="dateTimeFormat">
							<xsl:with-param name="data" select="$sign-date"/>
						</xsl:call-template>
					</xsl:if>
				</p>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
	<xsl:decimal-format name="pl" decimal-separator=',' grouping-separator=' ' />
	<xsl:template name="numberFormat">
			<xsl:param name="number" />
			<xsl:if test="$number">
				<xsl:value-of
					select="format-number($number, '### ##0,00', 'pl')" />
			</xsl:if>
	</xsl:template>
	
	<xsl:decimal-format name="version" decimal-separator='.'/>
	<xsl:template name="versionFormat">
			<xsl:param name="number" />
			<xsl:if test="$number">
				<xsl:value-of
					select="number" />
			</xsl:if>
	</xsl:template>
	
	<xsl:template name="dateFormat">
			<xsl:param name="data" />
			<xsl:if test="$data">
				<xsl:value-of
					select="concat(substring($data, 9, 2), '.', substring($data, 6, 2), '.', substring($data, 1, 4))" />
			</xsl:if>
	</xsl:template>
	
	<xsl:template name="dateTimeFormat">
		 <xsl:param name="data"/>
		 <xsl:if test="$data">
		 	<xsl:value-of select="concat(substring($data, 9, 2), '.', substring($data, 6, 2), '.', substring($data, 1, 4), ' ', substring($data, 12, 8))"/>	
		 </xsl:if>
	</xsl:template>
	
	<xsl:template name="dateTimeFormatYYYY-MM-DD">
		 <xsl:param name="data"/>
		 <xsl:if test="$data">
		 	<xsl:value-of select="concat(substring($data, 1, 10), ' ', substring($data, 12, 8))"/>	
		 </xsl:if>
	</xsl:template>
		
	 <xsl:template name="dateFormatMM-YYYY">
		 <xsl:param name="data"/>
		 <xsl:if test="$data">
		 	<xsl:value-of select="concat(substring($data, 6, 2), '-', substring($data, 1, 4))"/> 		
		 </xsl:if> 
	</xsl:template>
	
	<xsl:template name="dateFormatYYYY.MM">
		 <xsl:param name="data"/>
		 <xsl:if test="$data">
		 	<xsl:value-of select="concat(substring($data, 1, 4), '.', substring($data, 6, 2))"/> 		
		 </xsl:if> 
	</xsl:template>
	
	<xsl:template name="umowa-nfz">
		<xsl:param name="nr-umowy" />
		<xsl:param name="nr-umowy-druk" />
	
		<xsl:if test="$nr-umowy">
			<xsl:value-of select="$nr-umowy" />
			<xsl:if test="$nr-umowy-druk and ($nr-umowy-druk != $nr-umowy)">
				<br />
				<xsl:text>(</xsl:text>
				<xsl:value-of select="$nr-umowy-druk" />
				<xsl:text>)</xsl:text>
			</xsl:if>
		</xsl:if>
		<xsl:if test="not($nr-umowy)">
			<xsl:value-of select="$nr-umowy-druk" />
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="upraw-dod-dok">
		<xsl:param name="dokument"/>	
		<xsl:if test="$dokument">
			<xsl:value-of select="$dokument/@rodzaj-dokumentu" />
			<xsl:if test="$dokument/@rodzaj-dokumentu">
				<xsl:call-template name="slownikUprawnieniaDod">
					<xsl:with-param name="kodUprDod"
						select="$dokument/@rodzaj-dokumentu" />
				</xsl:call-template>
			</xsl:if>
		
			<xsl:if test="$dokument/@nr-dokumentu">
				<xsl:text> nr dok.: </xsl:text>
				<xsl:value-of select="$dokument/@nr-dokumentu" />
			</xsl:if>	
			<br />
			<xsl:choose>
				<xsl:when test="$dokument/@bezterminowy = 'T'">
					<xsl:text> data ważn.: bezterminowy </xsl:text>
				</xsl:when>
				<xsl:when test="$dokument/@data-waznosci">
					<xsl:text> data ważn.: </xsl:text>
					<xsl:call-template name="dateFormat">
						<xsl:with-param name="data"
							select="$dokument/@data-waznosci" />
					</xsl:call-template>
				</xsl:when>
			</xsl:choose>		
			<xsl:if test="$dokument/@data-wystawienia">
				<xsl:text> data wyst.: </xsl:text>
				<xsl:call-template name="dateFormat">
					<xsl:with-param name="data"
						select="$dokument/@data-wystawienia" />
				</xsl:call-template>
			</xsl:if>	
			<xsl:if test="$dokument/@npwz">
				<br />
				<xsl:text> NPWZ osoby wystawiającej: </xsl:text>
				<xsl:value-of select="$dokument/@npwz" />
			</xsl:if>
		</xsl:if>
	</xsl:template>
	
		<xsl:template name="miesiaceIteracja">
			<xsl:param name="lb-mies" />
			<xsl:param name="mies-od" />
			
			<xsl:call-template name="miesiaceLoop">
			  <xsl:with-param name="i" select="number(1)"/>	  
			  <xsl:with-param name="max" select="number($lb-mies)"/>
			  <xsl:with-param name="miesiac" select="number(substring($mies-od, 6, 2))"/>
			</xsl:call-template>

		</xsl:template>
		
			<xsl:template name="miesiaceLoop">
			  <xsl:param name="i"/>
			  <xsl:param name="max"/>
			  <xsl:param name="miesiac" />
			    	  
			  <xsl:if test="$i &lt;= $max">
				<xsl:if test="$i != 1">
				   <xsl:text>, </xsl:text>
				</xsl:if>
			  	<xsl:choose>
					<xsl:when test="$miesiac = 1">styczeń</xsl:when>
					<xsl:when test="$miesiac = 2">luty</xsl:when>
					<xsl:when test="$miesiac = 3">marzec</xsl:when>
					<xsl:when test="$miesiac = 4">kwiecień</xsl:when>
					<xsl:when test="$miesiac = 5">maj</xsl:when>
					<xsl:when test="$miesiac = 6">czerwiec</xsl:when>
					<xsl:when test="$miesiac = 7">lipiec</xsl:when>
					<xsl:when test="$miesiac = 8">sierpień</xsl:when>
					<xsl:when test="$miesiac = 9">wrzesień</xsl:when>
					<xsl:when test="$miesiac = 10">październik</xsl:when>
					<xsl:when test="$miesiac = 11">listopad</xsl:when>
					<xsl:when test="$miesiac = 12">grudzień</xsl:when>
				</xsl:choose>
				  		  
				<xsl:choose>
					<xsl:when test="$miesiac = 12">
						 <xsl:call-template name="miesiaceLoop">
					        <xsl:with-param name="i" select="$i + 1"/>
					        <xsl:with-param name="max" select="$max"/>
					        <xsl:with-param name="miesiac" select="number(1)"/>
					      </xsl:call-template>			
					</xsl:when>
					<xsl:otherwise>
						 <xsl:call-template name="miesiaceLoop">
					        <xsl:with-param name="i" select="$i + 1"/>
					        <xsl:with-param name="max" select="$max"/>
					        <xsl:with-param name="miesiac" select="$miesiac + 1"/>
					      </xsl:call-template>			
					</xsl:otherwise>
				</xsl:choose>  
	      
			  </xsl:if>
		</xsl:template>
		
		<xsl:template name="miesiaceIteracjaWithYear">
			<xsl:param name="lb-mies" />
			<xsl:param name="mies-od" />
			
			<xsl:call-template name="miesiaceLoopWithYear">
			  <xsl:with-param name="i" select="number(1)"/>	  
			  <xsl:with-param name="max" select="number($lb-mies)"/>
			  <xsl:with-param name="miesiac" select="number(substring($mies-od, 6, 2))"/>
			  <xsl:with-param name="year" select="number(substring($mies-od, 1, 4))"/>
			</xsl:call-template>

		</xsl:template>
		
			<xsl:template name="miesiaceLoopWithYear">
			  <xsl:param name="i"/>
			  <xsl:param name="max"/>
			  <xsl:param name="miesiac" />
			  <xsl:param name="year" />
			    	  
			  <xsl:if test="$i &lt;= $max">
				<xsl:if test="$i != 1">
				   <xsl:text>, </xsl:text>
				</xsl:if>
			  	<xsl:choose>
					<xsl:when test="$miesiac = 1">styczeń</xsl:when>
					<xsl:when test="$miesiac = 2">luty</xsl:when>
					<xsl:when test="$miesiac = 3">marzec</xsl:when>
					<xsl:when test="$miesiac = 4">kwiecień</xsl:when>
					<xsl:when test="$miesiac = 5">maj</xsl:when>
					<xsl:when test="$miesiac = 6">czerwiec</xsl:when>
					<xsl:when test="$miesiac = 7">lipiec</xsl:when>
					<xsl:when test="$miesiac = 8">sierpień</xsl:when>
					<xsl:when test="$miesiac = 9">wrzesień</xsl:when>
					<xsl:when test="$miesiac = 10">październik</xsl:when>
					<xsl:when test="$miesiac = 11">listopad</xsl:when>
					<xsl:when test="$miesiac = 12">grudzień</xsl:when>
				</xsl:choose>
				<xsl:text> </xsl:text> 
			 	<xsl:value-of select="$year" />	
				<xsl:choose>
					<xsl:when test="$miesiac = 12">
						 <xsl:call-template name="miesiaceLoopWithYear">
					        <xsl:with-param name="i" select="$i + 1"/>
					        <xsl:with-param name="max" select="$max"/>
					        <xsl:with-param name="miesiac" select="number(1)"/>
					         <xsl:with-param name="year" select="$year + 1"/>
					      </xsl:call-template>			
					</xsl:when>
					<xsl:otherwise>
						 <xsl:call-template name="miesiaceLoopWithYear">
					        <xsl:with-param name="i" select="$i + 1"/>
					        <xsl:with-param name="max" select="$max"/>
					        <xsl:with-param name="miesiac" select="$miesiac + 1"/>
					        <xsl:with-param name="year" select="$year"/>
					      </xsl:call-template>			
					</xsl:otherwise>
				</xsl:choose>  
	      
			  </xsl:if>
		</xsl:template>
		
		<xsl:template name="monthsInterval">
			<xsl:param name="lb-mies"/>
			<xsl:param name="mies-od"/>
			
			<xsl:if test="$mies-od">
				<xsl:call-template name="dateFormatYYYY.MM">
					<xsl:with-param name="data" select="$mies-od"></xsl:with-param>
				</xsl:call-template>
				<xsl:if test="$lb-mies and $lb-mies > 1">
					
				    <xsl:variable name="miesiac" select="number(substring($mies-od, 6, 2))"/>
					<xsl:text> - </xsl:text>
					<xsl:variable name="miesiac-do" select="$miesiac + number($lb-mies) - 1"/>
					<xsl:variable name="increment" select="floor(number($miesiac-do) div number(12))"/>			
					<xsl:variable name="year" select="number(substring($mies-od, 1, 4)) + $increment"/>
					<xsl:variable name="mies-do" select="$miesiac-do - ($increment * 12)"/>
					<xsl:choose>
							<xsl:when test="$mies-do = 0">
								<xsl:value-of select="concat($year, '.', '12')" />	 		
							</xsl:when>
							<xsl:when test="$mies-do > 0 and $mies-do &lt; 10">
								<xsl:value-of select="concat($year, '.', '0', $mies-do)" />	 		
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of
									select="concat($year, '.', $mies-do)" />			
							</xsl:otherwise>
						</xsl:choose>
				</xsl:if>
			</xsl:if>
		</xsl:template>
	
	<xsl:template name="translateOwCode">
		<xsl:param name="ow-nfz" />
		<xsl:value-of select="$ow-nfz" />
		<xsl:text> - </xsl:text>										
		<xsl:choose>
			<xsl:when test="$ow-nfz = '01'">Dolnośląski OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '02'">Kujawsko-Pomorski OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '03'">Lubelski OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '04'">Lubuski OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '05'">Łódzki  OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '06'">Małopolski  OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '07'">Mazowiecki OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '08'">Opolski OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '09'">Podkarpacki OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '10'">Podlaski OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '11'">Pomorski  OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '12'">Śląski OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '13'">Świętokrzyski OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '14'">Warmińsko-Mazurski OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '15'">Wielkopolski OW NFZ</xsl:when>
			<xsl:when test="$ow-nfz = '16'">Zachodniopomorski OW NFZ</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="slownikUprawnieniaDod">                    
		<xsl:param name="kodUprDod" />										
		<xsl:choose>
			<xsl:when test="$kodUprDod = '1'"> - Książka inwalidy wojennego - wojskowego</xsl:when>
			<xsl:when test="$kodUprDod = '2'"> - Legitymacja cywilnej niewidomej ofiary działań wojennych</xsl:when>
			<xsl:when test="$kodUprDod = '3'"> - Legitymacja osoby represjonowanej</xsl:when>
			<xsl:when test="$kodUprDod = '4'"> - Legitymacja osoby poszkodowanej poza granicami państwa</xsl:when>
			<xsl:when test="$kodUprDod = '5'"> - Karta - Dokument potwierdzający uprawnienia przysługujące weteranowi poszkodowanemu - funkcjonariuszowi do korzystania ze świadczeń opieki zdrowotnej. Ważny wraz z dokumentem tożsamości.</xsl:when>
			<xsl:when test="$kodUprDod = '6'"> - Legitymacja weterana poszkodowanego</xsl:when>
			<xsl:when test="$kodUprDod = '7'"> - Zaświadczenie lekarza podstawowej opieki zdrowotnej lub lekarza ubezpieczenia zdrowotnego posiadającego, specjalizację II stopnia lub tytuł specjalisty w dziedzinie położnictwa i ginekologii, perinatologii, neonatologii lub pediatrii, neurologii dziecięcej, kardiologii dziecięcej i chirurgii dziecięcej.</xsl:when>
			<xsl:when test="$kodUprDod = '8'"> - Orzeczenie o niepełnosprawności w stopniu znacznym (od 16 roku życia) albo inne traktowane równorzędnie (w tym wyroki sądowe i legitymacje)</xsl:when>
			<xsl:when test="$kodUprDod = '9'"> - Orzeczenie o niepełnosprawności (do 16 roku życia) łącznie ze wskazaniem konieczności stałej lub długotrwałej opieki lub pomocy innej osoby w związku ze znacznie ograniczoną możliwością samodzielnej egzystencji oraz konieczności stałego współudziału na co dzień opiekuna dziecka w procesie jego leczenia, rehabilitacji i edukacji.</xsl:when>
			<xsl:when test="$kodUprDod = '11'"> - Decyzja o przyznaniu statusu weterana poszkodowanego</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="slownikTytUprDod">                    
		<xsl:param name="kodTyt" />									
		<xsl:choose>
			<xsl:when test="$kodTyt = 'AL'"> - Świadczeniobiorcy inni niż ubezpieczeni - art. 12 pkt 2 [AL]</xsl:when>
			<xsl:when test="$kodTyt = 'BU'"> - Osoby, którym przysługują uprawnienia do swiadczeń zgodnie z art. 67 ust. 4 ustawy</xsl:when>	
			<xsl:when test="$kodTyt = 'CH'"> - Osoby, którym przysługują uprawnienia do swiadczeń zgodnie z art. 67 ust. 6 ustawy</xsl:when>
			<xsl:when test="$kodTyt = 'CU'"> - Świadczeniobiorcy inni niż ubezpieczeni - art. 12 pkt 5</xsl:when>
			<xsl:when test="$kodTyt = 'EM'"> - Osoby, którym przysługują uprawnienia do swiadczeń zgodnie z art. 67 ust. 7 ustawy</xsl:when>
			<xsl:when test="$kodTyt = 'I'"> - Świadczeniobiorcy inni niż ubezpieczeni - art. 2 ust. 1 pkt 3</xsl:when>
			<xsl:when test="$kodTyt = 'IA'"> - Osoby, którym przysługują uprawnienia do swiadczeń zgodnie z art. 2 ust. 1 pkt 3 lit. a ustawy</xsl:when>
			<xsl:when test="$kodTyt = 'IAU'"> - Osoby, którym przysługują uprawnienia do swiadczeń zgodnie z art. 2 ust. 1 pkt 3 lit. b ustawy</xsl:when>
			<xsl:when test="$kodTyt = 'IB'"> - Osoby, którym przysługują uprawnienia do swiadczeń zgodnie z art. 2 ust. 1 pkt 4 lit. a ustawy</xsl:when>
			<xsl:when test="$kodTyt = 'IBU'"> - Osoby, którym przysługują uprawnienia do swiadczeń zgodnie z art. 2 ust. 1 pkt 4 lit. b ustawy</xsl:when>	
			<xsl:when test="$kodTyt = 'N'"> - Świadczeniobiorcy inni niż ubezpieczeni - art. 2 ust. 1 pkt 2 [N]</xsl:when>
			<xsl:when test="$kodTyt = 'NA'"> - Świadczeniobiorcy inni niż ubezpieczeni - art. 12 pkt 3 [NA]</xsl:when>
			<xsl:when test="$kodTyt = 'PS'"> - Świadczeniobiorcy inni niż ubezpieczeni - art. 12 pkt 4 [PS]   </xsl:when>
			<xsl:when test="$kodTyt = 'RP'"> - Świadczeniobiorcy inni niż ubezpieczeni - art. 12 pkt 9 [RP]</xsl:when>	
			<xsl:when test="$kodTyt = 'U'"> - Ubezpieczeni</xsl:when>
			<xsl:when test="$kodTyt = 'UA'"> - Osoby, którym przysługują uprawnienia do swiadczeń zgodnie z art. 12 pkt 13 ustawy</xsl:when>
			<xsl:when test="$kodTyt = 'UC'"> - Osoby, którym przysługują uprawnienia do swiadczeń zgodnie z art. 67 ust. 5 ustawy</xsl:when>
			<xsl:when test="$kodTyt = 'UE'"> - Uprawnieni do świadczeń na podstawie przepisów o koordynacji</xsl:when>
			<xsl:when test="$kodTyt = 'ZA'"> - Świadczeniobiorcy inni niż ubezpieczeni - art. 12 pkt 6 [ZA]</xsl:when>
			<xsl:when test="$kodTyt = 'IC'"> - Świadczeniobiorca o  którym mowa w art. 2 ust. 1 pkt 3 lit. c ustawy</xsl:when>
			<xsl:when test="$kodTyt = 'TR'"> - Osoby uprawnione na podstawie art. 37 ust. 1b ustawy z dnia 12 marca 2022 r. o pomocy obywatelom Ukrainy</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="potwPrawaDokumentRodzaj">
		<xsl:param name="kodDok" />										
		<xsl:choose>	
			<xsl:when test="$kodDok = '1'"> - Karta ubezpieczenia zdrowotnego</xsl:when>
			<xsl:when test="$kodDok = '2'"> - Inny dokument poświadczający ubezpieczenie zdrowotne</xsl:when>
			<xsl:when test="$kodDok = '3'"> - Decyzja wójta / burmistrza</xsl:when>
			<xsl:when test="$kodDok = '4'"> - Europejskie Karty Ubezpieczenia Zdrowotnego</xsl:when>
			<xsl:when test="$kodDok = '5'"> - Poświadczenie wydane do druku E106</xsl:when>
			<xsl:when test="$kodDok = '6'"> - Poświadczenie wydane do druku E109</xsl:when>
			<xsl:when test="$kodDok = '7'"> - Poświadczenie wydane do druku E120</xsl:when>
			<xsl:when test="$kodDok = '8'"> - Poświadczenie wydane do druku E121</xsl:when>
			<xsl:when test="$kodDok = '9'"> - Poświadczenie wydane do druku E123</xsl:when>
			<xsl:when test="$kodDok = '10'"> - Druk E106</xsl:when>
			<xsl:when test="$kodDok = '11'"> - Druk E109</xsl:when>
			<xsl:when test="$kodDok = '12'"> - Druk E110</xsl:when>
			<xsl:when test="$kodDok = '13'"> - Druk E111</xsl:when>
			<xsl:when test="$kodDok = '14'"> - Druk E111B</xsl:when>
			<xsl:when test="$kodDok = '15'"> - Druk E112</xsl:when>
			<xsl:when test="$kodDok = '16'"> - Druk E119</xsl:when>		
			<xsl:when test="$kodDok = '17'"> - Druk E120</xsl:when>
			<xsl:when test="$kodDok = '18'"> - Druk E121</xsl:when>
			<xsl:when test="$kodDok = '19'"> - Druk E123</xsl:when>
			<xsl:when test="$kodDok = '20'"> - Druk E128</xsl:when>
			<xsl:when test="$kodDok = '21'"> - Certyfikaty</xsl:when>
			<xsl:when test="$kodDok = '28'"> - Inny dokument potwierdzający uprawnienia [I]</xsl:when>
			<xsl:when test="$kodDok = '29'"> - Inny dokument potwierdzający uprawnienia [AL]</xsl:when>
			<xsl:when test="$kodDok = '30'"> - Inny dokument potwierdzający uprawnienia [NA]</xsl:when>
			<xsl:when test="$kodDok = '31'"> - Inny dokument potwierdzający uprawnienia [PS]</xsl:when>
			<xsl:when test="$kodDok = '32'"> - Inny dokument potwierdzający uprawnienia [ZA]</xsl:when>
			<xsl:when test="$kodDok = '33'"> - Karta Polaka</xsl:when>
			<xsl:when test="$kodDok = '36'"> - Druk S1</xsl:when>
			<xsl:when test="$kodDok = '37'"> - Druk S2</xsl:when>
			<xsl:when test="$kodDok = '38'"> - Druk S3</xsl:when>
			<xsl:when test="$kodDok = '39'"> - Druk DA1</xsl:when>		
			<xsl:when test="$kodDok = '43'"> - Inny dokument potwierdzający uprawnienia [UC]</xsl:when>
			<xsl:when test="$kodDok = '44'"> - Inny dokument potwierdzający uprawnienia [CH]</xsl:when>
			<xsl:when test="$kodDok = '45'"> - Inny dokument potwierdzający uprawnienia [EM]</xsl:when>
			<xsl:when test="$kodDok = '46'"> - Inny dokument potwierdzający uprawnienia [Ia]</xsl:when>
			<xsl:when test="$kodDok = '47'"> - Inny dokument potwierdzający uprawnienia [IB]</xsl:when>
			<xsl:when test="$kodDok = '51'"> - Oświadczenie [U]</xsl:when>
			<xsl:when test="$kodDok = '52'"> - Oświadczenie [Ia]</xsl:when>
			<xsl:when test="$kodDok = '53'"> - Oświadczenie [IB]</xsl:when>
			<xsl:when test="$kodDok = '54'"> - Oświadczenie [UC]</xsl:when>
			<xsl:when test="$kodDok = '55'"> - Oświadczenie [CH]</xsl:when>
			<xsl:when test="$kodDok = '56'"> - Oświadczenie [EM]</xsl:when>
			<xsl:when test="$kodDok = '57'"> - Oświadczenie [N]</xsl:when>
			<xsl:when test="$kodDok = '58'"> - RMUA</xsl:when>
			<xsl:when test="$kodDok = '59'"> - Legitymacja ubezpieczeniowa</xsl:when>
			<xsl:when test="$kodDok = '60'"> - Legitymacja emeryta lub rencisty</xsl:when>
			<xsl:when test="$kodDok = '61'"> - Zgłoszenie do ubezpieczenia</xsl:when>
			<xsl:when test="$kodDok = '62'"> - Zaświadczenie potwierdzające prawo</xsl:when>
			<xsl:when test="$kodDok = '63'"> - EWUŚ [U]</xsl:when>
			<xsl:when test="$kodDok = '64'"> - EWUŚ [Ia]</xsl:when>		
			<xsl:when test="$kodDok = '66'"> - Inny [CU]</xsl:when>
			<xsl:when test="$kodDok = '68'"> - EWUŚ [CH]</xsl:when>
			<xsl:when test="$kodDok = '69'"> - EWUŚ [EM]</xsl:when>
			<xsl:when test="$kodDok = '70'"> - Inny dokument potwierdzający uprawnienia [IAU]</xsl:when>
			<xsl:when test="$kodDok = '71'"> - Inny dokument potwierdzający uprawnienia [IBU]</xsl:when>
			<xsl:when test="$kodDok = '72'"> - Oświadczenie [IAU]</xsl:when>	
			<xsl:when test="$kodDok = '73'"> - Oświadczenie [IBU]</xsl:when>
			<xsl:when test="$kodDok = '74'"> - Inny [BU]</xsl:when>
			<xsl:when test="$kodDok = '76'"> - Karta pobytu [CU]</xsl:when>
			<xsl:when test="$kodDok = '77'"> - Karta pobytu [IAU]</xsl:when>
			<xsl:when test="$kodDok = '78'"> - Karta pobytu [IBU]</xsl:when>
			<xsl:when test="$kodDok = '79'"> - Oświadczenie [BU]</xsl:when>	
			<xsl:when test="$kodDok = '80'"> - Ewuś Poś. wydane do druku E106</xsl:when>
			<xsl:when test="$kodDok = '81'"> - Ewuś Poś. wydane do druku E109</xsl:when>
			<xsl:when test="$kodDok = '82'"> - Ewuś Poś. wydane do druku E120</xsl:when>
			<xsl:when test="$kodDok = '83'"> - Ewuś Poś. wydane do druku E121</xsl:when>	
			<xsl:when test="$kodDok = '84'"> - EWUŚ Decyzja wójta / burmistrza</xsl:when>
			<xsl:when test="$kodDok = '85'"> - Poświadczenie wydane do dokumentu przenośnego S1</xsl:when>
			<xsl:when test="$kodDok = '86'"> - Poświadczenie wydane do dokumentu przenośnego DA1</xsl:when>
			<xsl:when test="$kodDok = '87'"> - Poświadczenie wydane do SED DA002</xsl:when>
			<xsl:when test="$kodDok = '88'"> - Poświadczenie wydane do SED S072</xsl:when>
			<xsl:when test="$kodDok = '89'"> - EWUŚ Poś. wydane do SED S072</xsl:when>
			<xsl:when test="$kodDok = '90'"> - EWUŚ Poś. wydane do S1</xsl:when>
			<xsl:when test="$kodDok = '91'"> - Inny dokument poświadczający ubezpieczenie zdrowotne</xsl:when>
			<xsl:when test="$kodDok = '93'"> - EWUŚ [UA]</xsl:when>
			<xsl:when test="$kodDok = '94'"> - Oświadczenie [UA]</xsl:when>
			<xsl:when test="$kodDok = '95'"> - Paszport</xsl:when>
			<xsl:when test="$kodDok = '96'"> - Dokumentu ze straży granicznej potwierdzającego przekroczenie granicy</xsl:when>
			<xsl:when test="$kodDok = '97'"> - Zaświadczenia z gminy o złożeniu wniosku o nadanie numeru PESEL</xsl:when>
			<xsl:when test="$kodDok = '98'"> - EWUŚ [IC]</xsl:when>
			<xsl:when test="$kodDok = '99'"> - Oświadczenie [IC]</xsl:when>
			<xsl:when test="$kodDok = '100'"> - Dokument potwierdzający przyznanie lub posiadanie prawa do renty rodzinnej</xsl:when>
			<xsl:when test="$kodDok = '101'"> - Dokument wystawiony przez ministra właściwego do spraw zdrowia potwierdzający prawo do świadczeń opieki zdrowotnej na podstawie art. 37 ust.1b ustawy zbrojnym na terytorium tego państwa z dnia 12 marca 2022 r. o pomocy obywatelom Ukrainy w związku z konfliktem zbrojnym na terytorium tego państwa</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="slownikKryteriumSkrocenieOkresuMz">                    
		<xsl:param name="kryterium" />										
		<xsl:choose>
			<xsl:when test="$kryterium = '1'"> - w przypadkach zmian w stanie fizycznym powodujących konieczność skrócenia okresu użytkowania wyrobu medycznego, a możliwości regulacji tego wyrobu zostały wyczerpane</xsl:when>
			<xsl:when test="$kryterium = '2'"> - zabiegów chirurgicznych</xsl:when>
			<xsl:when test="$kryterium = '3'"> - jednostek chorobowych powodujących konieczność skrócenia okresu użytkowania wyrobu medycznego</xsl:when>
			<xsl:when test="$kryterium = '4'"> - rehabilitacji</xsl:when>
			<xsl:when test="$kryterium = '5'"> - rozwoju fizycznego</xsl:when>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="StyleWspolne">
		<style type="text/css"><![CDATA[
		body {
			background-color: #FFFFFF;
			color: #000000;
			font-family: 'Arial', sans-serif;
			font-size: 11pt;
			margin: 0;
			padding: 1px 5%;
		}
		
		div.body {
			width: 100%;
			min-width: 480px;
			margin-left: auto;
			margin-right: auto;
		}
		
		p {
			padding: 2px;
			margin: 0.2em 0;
		}
		
		table {
			border-collapse: collapse;
			margin: 8px 0px 8px 0px;
		}
		
		input[type=checkbox] {
		 	width: 19px;
		 	box-shadow: 0 1px 2px rgba(0,0,0,0.05), inset 0px 1px 3px rgba(0,0,0,0.1);
		 	height: 19px;
		 	background-repeat:no-repeat;
			background-position: 0 0;
		 	vertical-align: middle;
		 	color: #000000 important!;
			background-color: #FFFFFF important!;
		} 
		
		input[type=checkbox]:disabled + label {
			color: #000000 important!;
			background-color: #FFFFFF important!;
		}

		div.naglowek {
			align: left;
			font-size: 20px; 	
			background-color: #DDDDDD; 
			padding: 5px;
			border-style: solid;
		}
		
		div.sekcja {
			 font-size: 16px; 
			 border-style: solid; 
			 padding: 5px;  
			 border-style: 1px solid;
		}
		
		div.blad {
			text-align: center; 
			height: 60px; 
			font-size: 20px; 
			background-color: #DDDDDD; 
			padding: 5px;
			border-style: 1px solid;
		}
		
		div.podtytul {
			font-size: 14px;
			margin-top: 20px;
			margin-bottom: 8px;
			margin-left: 2%; 
			width: 97%;
			text-align: left;
			font-weight: bold;
		}
		
		table.rubryka, table.tabela {
			width: 97%; 
			margin-left: auto; 
			margin-right: auto;
			margin-top: 8px;
			margin-bottom: 8px;
			padding: 5px;
		}
		
		th, td {
			border: 1px solid #000000;
		}
		
		
		table.rubryka td, td.pole, table.tabela td {
			text-align: center;
			vertical-align: middle; 
			font-size: 16px;
			word-wrap: break-word;
		}
			
		table.rubryka th, th.opis-pola {
			border-bottom: 1px solid #FFFFFF;
			font-size: 12px; 
			font-weight: bold; 
			height: 10px;
			padding: 5px;
			text-align: left;
			vertical-align: top;
		}
		
		table.tabela th {
			font-size: 12px; 
			font-weight: bold; 
			height: 10px;
			padding: 5px;
			text-align: left;
			vertical-align: top;
		}
		
		td.left, th.left {
			text-align: left !important;
			padding: 10px !important;
		}
		
		td.top, th.top {
			vertical-align: top !important;
			margin-top: 5px !important;
		}
				
		h1 {
			font-size: 1.4em;
			font-weight: bold;
			text-align: center;
			text-transform: uppercase;
		}
		
		h2 {
			text-align: left;
			font-size: 1.2em;
			font-weight: bold; 
		}
		
		h3 {
			text-align: left;
			font-size: 1.2em;
			font-weight: normal;
		}
		
		h4 {
			text-align: left;
			font-size: 1em;
			font-weight: normal;
		}
		
		h1, h2, h3, h4 {
			font-family: 'Arial', sans-serif;
			margin: 0;
			padding: 1px;
		}
		
		]]></style>
		
			</xsl:template>
		</xsl:stylesheet>
